/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import java.lang.reflect.Method;
import java.util.List;

public class AlloyServiceInvoker {
    protected Method addModelMethod;
    protected Method createModelMethod;
    protected Method deleteModelMethod;
    protected Method dynamicQueryCountMethod1;
    protected Method dynamicQueryCountMethod2;
    protected Method dynamicQueryMethod1;
    protected Method dynamicQueryMethod2;
    protected Method dynamicQueryMethod3;
    protected Method dynamicQueryMethod4;
    protected Method fetchModelMethod;
    protected Method getModelMethod;
    protected Method getModelsCountMethod;
    protected Method getModelsMethod;
    protected IdentifiableOSGiService identifiableOSGiService;
    protected Method updateModelMethod;

    public AlloyServiceInvoker(String className) {
        int pos = className.indexOf(".model.");
        String simpleClassName = className.substring(pos + 7);
        String serviceClassName = StringBundler.concat((String[])new String[]{className.substring(0, pos), ".service.", simpleClassName, "LocalService"});
        try {
            this.identifiableOSGiService = IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)serviceClassName);
            Class<?> serviceClass = this.identifiableOSGiService.getClass();
            this.createModelMethod = serviceClass.getMethod("create" + simpleClassName, Long.TYPE);
            Class<?> modelClass = this.createModelMethod.getReturnType();
            this.addModelMethod = serviceClass.getMethod("add" + simpleClassName, modelClass);
            this.deleteModelMethod = serviceClass.getMethod("delete" + simpleClassName, Long.TYPE);
            this.dynamicQueryCountMethod1 = serviceClass.getMethod("dynamicQueryCount", DynamicQuery.class);
            this.dynamicQueryCountMethod2 = serviceClass.getMethod("dynamicQueryCount", DynamicQuery.class, Projection.class);
            this.dynamicQueryMethod1 = serviceClass.getMethod("dynamicQuery", new Class[0]);
            this.dynamicQueryMethod2 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class);
            this.dynamicQueryMethod3 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class, Integer.TYPE, Integer.TYPE);
            this.dynamicQueryMethod4 = serviceClass.getMethod("dynamicQuery", DynamicQuery.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class);
            this.fetchModelMethod = serviceClass.getMethod("fetch" + simpleClassName, Long.TYPE);
            this.getModelMethod = serviceClass.getMethod("get" + simpleClassName, Long.TYPE);
            this.getModelsCountMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName) + "Count", new Class[0]);
            this.getModelsMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName), Integer.TYPE, Integer.TYPE);
            this.updateModelMethod = serviceClass.getMethod("update" + simpleClassName, modelClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BaseModel addModel(BaseModel baseModel) throws Exception {
        return (BaseModel)this.addModelMethod.invoke((Object)this.identifiableOSGiService, baseModel);
    }

    public DynamicQuery buildDynamicQuery() throws Exception {
        return (DynamicQuery)this.dynamicQueryMethod1.invoke((Object)this.identifiableOSGiService, new Object[0]);
    }

    public DynamicQuery buildDynamicQuery(Object[] properties) throws Exception {
        if (properties.length == 0 || properties.length % 2 != 0) {
            throw new IllegalArgumentException("Properties length is not an even number");
        }
        DynamicQuery dynamicQuery = this.buildDynamicQuery();
        for (int i = 0; i < properties.length; i += 2) {
            String propertyName = String.valueOf(properties[i]);
            Property property = PropertyFactoryUtil.forName((String)propertyName);
            Object propertyValue = properties[i + 1];
            dynamicQuery.add(property.eq(propertyValue));
        }
        return dynamicQuery;
    }

    public BaseModel createModel(long id) throws Exception {
        return (BaseModel)this.createModelMethod.invoke((Object)this.identifiableOSGiService, id);
    }

    public BaseModel<?> deleteModel(BaseModel<?> baseModel) throws Exception {
        return (BaseModel)this.deleteModelMethod.invoke((Object)this.identifiableOSGiService, baseModel.getPrimaryKeyObj());
    }

    public BaseModel<?> deleteModel(long classPK) throws Exception {
        return (BaseModel)this.deleteModelMethod.invoke((Object)this.identifiableOSGiService, classPK);
    }

    @Deprecated
    public List dynamicQuery(DynamicQuery dynamicQuery) throws Exception {
        return this.executeDynamicQuery(dynamicQuery);
    }

    @Deprecated
    public long dynamicQueryCount(DynamicQuery dynamicQuery) throws Exception {
        return this.executeDynamicQueryCount(dynamicQuery);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery) throws Exception {
        return (List)this.dynamicQueryMethod2.invoke((Object)this.identifiableOSGiService, dynamicQuery);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws Exception {
        return (List)this.dynamicQueryMethod3.invoke((Object)this.identifiableOSGiService, dynamicQuery, start, end);
    }

    public List executeDynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<?> obc) throws Exception {
        return (List)this.dynamicQueryMethod4.invoke((Object)this.identifiableOSGiService, dynamicQuery, start, end, obc);
    }

    public List executeDynamicQuery(Object[] properties) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties));
    }

    public List executeDynamicQuery(Object[] properties, int start, int end) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties), start, end);
    }

    public List executeDynamicQuery(Object[] properties, int start, int end, OrderByComparator<?> obc) throws Exception {
        return this.executeDynamicQuery(this.buildDynamicQuery(properties), start, end, obc);
    }

    public long executeDynamicQueryCount(DynamicQuery dynamicQuery) throws Exception {
        return (Long)this.dynamicQueryCountMethod1.invoke((Object)this.identifiableOSGiService, dynamicQuery);
    }

    public long executeDynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) throws Exception {
        return (Long)this.dynamicQueryCountMethod2.invoke((Object)this.identifiableOSGiService, dynamicQuery, projection);
    }

    public long executeDynamicQueryCount(Object[] properties) throws Exception {
        return this.executeDynamicQueryCount(this.buildDynamicQuery(properties));
    }

    public BaseModel<?> fetchModel(long classPK) throws Exception {
        return (BaseModel)this.fetchModelMethod.invoke((Object)this.identifiableOSGiService, classPK);
    }

    public BaseModel<?> getModel(long classPK) throws Exception {
        return (BaseModel)this.getModelMethod.invoke((Object)this.identifiableOSGiService, classPK);
    }

    public List getModels(int start, int end) throws Exception {
        return (List)this.getModelsMethod.invoke((Object)this.identifiableOSGiService, start, end);
    }

    public int getModelsCount() throws Exception {
        return (Integer)this.getModelsCountMethod.invoke((Object)this.identifiableOSGiService, new Object[0]);
    }

    public BaseModel<?> updateModel(BaseModel baseModel) throws Exception {
        return (BaseModel)this.updateModelMethod.invoke((Object)this.identifiableOSGiService, baseModel);
    }
}

