/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.util;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.RegionLocalization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class CompanyCountriesUtil {
    private static final Log _log = LogFactoryUtil.getLog(CompanyCountriesUtil.class);

    public static void addCountry(Company company, CounterLocalService counterLocalService, JSONObject countryJSONObject, CountryLocalService countryLocalService, Connection connection) throws Exception {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(company.getCompanyId());
            User guestUser = company.getGuestUser();
            serviceContext.setUserId(guestUser.getUserId());
            Country country = countryLocalService.addCountry(countryJSONObject.getString("a2"), countryJSONObject.getString("a3"), true, true, countryJSONObject.getString("idd"), countryJSONObject.getString("name"), countryJSONObject.getString("number"), 0.0, true, false, countryJSONObject.getBoolean("zipRequired"), serviceContext);
            HashMap<String, String> titleMap = new HashMap<String, String>();
            for (Locale locale : LanguageUtil.getCompanyAvailableLocales((long)company.getCompanyId())) {
                titleMap.put(LanguageUtil.getLanguageId((Locale)locale), country.getName(locale));
            }
            countryLocalService.updateCountryLocalizations(country, titleMap);
            CompanyCountriesUtil.processCountryRegions(country, connection, counterLocalService);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    public static JSONArray getJSONArray(String path) throws Exception {
        ClassLoader classLoader = CompanyCountriesUtil.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(path);){
            if (inputStream == null) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray jSONArray = JSONFactoryUtil.createJSONArray((String)StringUtil.read((InputStream)inputStream));
            return jSONArray;
        }
    }

    public static void populateCompanyCountries(Company company, CounterLocalService counterLocalService, CountryLocalService countryLocalService, Connection connection) throws Exception {
        int count = countryLocalService.getCompanyCountriesCount(company.getCompanyId());
        if (count > 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping country initialization. Countries are ", "already initialized for company ", company.getCompanyId(), "."}));
            }
            return;
        }
        CompanyCountriesUtil.updateRegionCounter(connection, counterLocalService);
        CompanyCountriesUtil.updateRegionLocalizationCounter(connection, counterLocalService);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing countries for company " + company.getCompanyId()));
        }
        JSONArray countriesJSONArray = CompanyCountriesUtil.getJSONArray("com/liferay/address/dependencies/countries.json");
        for (int i = 0; i < countriesJSONArray.length(); ++i) {
            JSONObject countryJSONObject = countriesJSONArray.getJSONObject(i);
            try {
                CompanyCountriesUtil.addCountry(company, counterLocalService, countryJSONObject, countryLocalService, connection);
                continue;
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    public static void processCountryRegions(Country country, Connection connection, CounterLocalService counterLocalService) throws Exception {
        String a2 = country.getA2();
        String path = "com/liferay/address/dependencies/regions/" + a2 + ".json";
        JSONArray regionsJSONArray = CompanyCountriesUtil.getJSONArray(path);
        if (regionsJSONArray == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Regions found for country " + a2));
        }
        if (regionsJSONArray.length() == 0) {
            return;
        }
        try (PreparedStatement regionPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)StringBundler.concat((String[])new String[]{"INSERT INTO Region (mvccVersion, ctCollectionId", ", uuid_, regionId, companyId, userId, createDate", ", modifiedDate, countryId, active_, name", ", position, regionCode) VALUES (0, 0, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, 0, ?)"}));
             PreparedStatement regionLocalizationPreparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)StringBundler.concat((String[])new String[]{"INSERT INTO RegionLocalization (mvccVersion, ", "ctCollectionId, regionLocalizationId, companyId", ", regionId, languageId, title) VALUES (0, 0, ?, ?, ", "?, ?, ?)"}));){
            int length = regionsJSONArray.length();
            long startRegionId = counterLocalService.increment(Region.class.getName(), length) - (long)length;
            ArrayList<RegionLocalizationData> regionLocalizationDataList = new ArrayList<RegionLocalizationData>();
            for (int i = 0; i < length; ++i) {
                JSONObject regionJSONObject = regionsJSONArray.getJSONObject(i);
                long regionId = startRegionId + (long)i + 1L;
                CompanyCountriesUtil._addRegionBatch(regionPreparedStatement, country.getCompanyId(), country.getCountryId(), regionJSONObject.getString("name"), regionJSONObject.getString("regionCode"), regionId, country.getUserId());
                JSONObject localizationsJSONObject = regionJSONObject.getJSONObject("localizations");
                if (localizationsJSONObject == null) {
                    for (Locale locale : LanguageUtil.getCompanyAvailableLocales((long)country.getCompanyId())) {
                        regionLocalizationDataList.add(new RegionLocalizationData(LanguageUtil.getLanguageId((Locale)locale), regionId, regionJSONObject.getString("name")));
                    }
                    continue;
                }
                for (String key : localizationsJSONObject.keySet()) {
                    regionLocalizationDataList.add(new RegionLocalizationData(key, regionId, localizationsJSONObject.getString(key)));
                }
            }
            long regionLocalizationId = counterLocalService.increment(RegionLocalization.class.getName(), regionLocalizationDataList.size());
            long startRegionLocalizationId = regionLocalizationId - (long)regionLocalizationDataList.size();
            for (RegionLocalizationData regionLocalizationData : regionLocalizationDataList) {
                CompanyCountriesUtil._addRegionLocalizationBatch(regionLocalizationPreparedStatement, country.getCompanyId(), regionLocalizationData._languageId, regionLocalizationData._regionId, ++startRegionLocalizationId, regionLocalizationData._title);
            }
            regionPreparedStatement.executeBatch();
            regionLocalizationPreparedStatement.executeBatch();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public static void updateRegionCounter(Connection connection, CounterLocalService counterLocalService) throws Exception {
        CompanyCountriesUtil._updateCounter(Region.class.getName(), connection, counterLocalService, "regionId", "Region");
    }

    public static void updateRegionLocalizationCounter(Connection connection, CounterLocalService counterLocalService) throws Exception {
        CompanyCountriesUtil._updateCounter(RegionLocalization.class.getName(), connection, counterLocalService, "regionLocalizationId", "RegionLocalization");
    }

    private static void _addRegionBatch(PreparedStatement preparedStatement, long companyId, long countryId, String name, String regionCode, long regionId, long userId) throws SQLException {
        preparedStatement.setString(1, PortalUUIDUtil.generate());
        preparedStatement.setLong(2, regionId);
        preparedStatement.setLong(3, companyId);
        preparedStatement.setLong(4, userId);
        preparedStatement.setDate(5, new Date(System.currentTimeMillis()));
        preparedStatement.setDate(6, new Date(System.currentTimeMillis()));
        preparedStatement.setLong(7, countryId);
        preparedStatement.setBoolean(8, true);
        preparedStatement.setString(9, name);
        preparedStatement.setString(10, regionCode);
        preparedStatement.addBatch();
    }

    private static void _addRegionLocalizationBatch(PreparedStatement preparedStatement, long companyId, String languageId, long regionId, long regionLocalizationId, String title) throws SQLException {
        preparedStatement.setLong(1, regionLocalizationId);
        preparedStatement.setLong(2, companyId);
        preparedStatement.setLong(3, regionId);
        preparedStatement.setString(4, languageId);
        preparedStatement.setString(5, title);
        preparedStatement.addBatch();
    }

    private static void _updateCounter(String className, Connection connection, CounterLocalService counterLocalService, String primaryKey, String tableName) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select currentId from Counter where name = ?");){
            preparedStatement.setString(1, className);
            long currentId = 0L;
            try (ResultSet resultSet1 = preparedStatement.executeQuery();){
                if (resultSet1.next()) {
                    currentId = resultSet1.getLong("currentId");
                }
            }
            var10_11 = null;
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet2 = statement.executeQuery(StringBundler.concat((String[])new String[]{"select max(", primaryKey, ") from ", tableName}));){
                long increment;
                if (resultSet2.next() && (increment = Math.max(0L, resultSet2.getLong(1) - currentId)) > 0L) {
                    counterLocalService.increment(className, (int)increment);
                }
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
        }
    }

    private static class RegionLocalizationData {
        private final String _languageId;
        private final long _regionId;
        private final String _title;

        private RegionLocalizationData(String languageId, long regionId, String title) {
            this._languageId = languageId;
            this._regionId = regionId;
            this._title = title;
        }
    }
}

