/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.upgrade.v1_0_2;

import com.liferay.address.internal.util.CompanyCountriesUtil;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.sql.PreparedStatement;
import java.util.Map;

public class CountryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CountryUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final CounterLocalService _counterLocalService;
    private final CountryLocalService _countryLocalService;
    private final JSONFactory _jsonFactory;
    private final RegionLocalService _regionLocalService;

    public CountryUpgradeProcess(CompanyLocalService companyLocalService, CounterLocalService counterLocalService, CountryLocalService countryLocalService, JSONFactory jsonFactory, RegionLocalService regionLocalService) {
        this._companyLocalService = companyLocalService;
        this._counterLocalService = counterLocalService;
        this._countryLocalService = countryLocalService;
        this._jsonFactory = jsonFactory;
        this._regionLocalService = regionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._addCountry((Company)company, HashMapBuilder.put((Object)"a2", (Object)"HK").put((Object)"a3", (Object)"HKG").put((Object)"idd", (Object)852).put((Object)"name", (Object)"hong-kong").put((Object)"number", (Object)344).put((Object)"zipRequired", (Object)false).build());
                this._addCountry((Company)company, HashMapBuilder.put((Object)"a2", (Object)"MO").put((Object)"a3", (Object)"MAC").put((Object)"idd", (Object)853).put((Object)"name", (Object)"macau").put((Object)"number", (Object)446).put((Object)"zipRequired", (Object)true).build());
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to populate company " + company.getCompanyId()), (Throwable)exception);
            }
        });
    }

    private void _addCountry(Company company, Map<String, Object> countryMap) throws Exception {
        Country country = this._countryLocalService.fetchCountryByA2(company.getCompanyId(), countryMap.get("a2").toString());
        if (country != null) {
            return;
        }
        CompanyCountriesUtil.addCountry(company, this._counterLocalService, this._jsonFactory.createJSONObject(countryMap), this._countryLocalService, this.connection);
        Country chinaCountry = this._countryLocalService.fetchCountryByA2(company.getCompanyId(), "CN");
        if (chinaCountry == null) {
            return;
        }
        Region region = this._regionLocalService.fetchRegion(chinaCountry.getCountryId(), countryMap.get("a2").toString());
        if (region == null) {
            return;
        }
        country = this._countryLocalService.fetchCountryByA2(company.getCompanyId(), countryMap.get("a2").toString());
        this._updateData(country.getCountryId(), chinaCountry.getCountryId(), region.getRegionId(), "Address");
        this._updateData(country.getA2(), chinaCountry.getA2(), region.getRegionCode(), "CIWarehouse");
        this._updateData(country.getCountryId(), chinaCountry.getCountryId(), region.getRegionId(), "CommerceTaxFixedRateAddressRel");
        this._updateData(country.getCountryId(), chinaCountry.getCountryId(), region.getRegionId(), "CShippingFixedOptionRel");
        this._updateData(country.getCountryId(), chinaCountry.getCountryId(), region.getRegionId(), "Organization_");
        this._regionLocalService.deleteRegion(region.getRegionId());
    }

    private void _updateData(long countryId, long oldCountryId, long oldRegionId, String tableName) throws Exception {
        if (this.hasTable(tableName)) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set countryId = ?, regionId = 0 where countryId ", "= ? and regionId = ?"}));){
                preparedStatement.setLong(1, countryId);
                preparedStatement.setLong(2, oldCountryId);
                preparedStatement.setLong(3, oldRegionId);
                preparedStatement.executeUpdate();
            }
        }
    }

    private void _updateData(String countryA2, String oldCountryA2, String oldRegionCode, String tableName) throws Exception {
        if (this.hasTable(tableName)) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set commerceRegionCode = null, ", "countryTwoLettersISOCode = ? where ", "commerceRegionCode = ? and ", "countryTwoLettersISOCode = ?"}));){
                preparedStatement.setString(1, countryA2);
                preparedStatement.setString(2, oldRegionCode);
                preparedStatement.setString(3, oldCountryA2);
                preparedStatement.executeUpdate();
            }
        }
    }
}

