/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CountryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CountryUpgradeProcess.class);
    private final ClassLoader _classLoader;
    private Set<Locale> _companyAvailableLocales;
    private Date _companyDate;
    private User _companyGuestUser;
    private final CompanyLocalService _companyLocalService;
    private PreparedStatement _countryLocalizationPreparedStatement;
    private PreparedStatement _countryPreparedStatement;
    private final Map<Locale, String> _localesLanguageIds = new HashMap<Locale, String>();
    private PreparedStatement _regionLocalizationPreparedStatement;
    private PreparedStatement _regionPreparedStatement;

    public CountryUpgradeProcess(CompanyLocalService companyLocalService) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._classLoader = clazz.getClassLoader();
        this._companyLocalService = companyLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._updateRegionCounter();
        this._companyLocalService.forEachCompany(company -> {
            try {
                this._populateCompanyCountries((Company)company);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to populate company " + company.getCompanyId()), (Throwable)exception);
            }
        });
    }

    private void _addCountry(Company company, JSONObject countryJSONObject) throws Exception {
        long countryId = this.increment();
        this._countryPreparedStatement.setLong(1, 0L);
        this._countryPreparedStatement.setString(2, PortalUUIDUtil.generate());
        this._countryPreparedStatement.setString(3, UpgradeProcessUtil.getDefaultLanguageId((long)company.getCompanyId()));
        this._countryPreparedStatement.setLong(4, countryId);
        this._countryPreparedStatement.setLong(5, company.getCompanyId());
        this._countryPreparedStatement.setLong(6, this._companyGuestUser.getUserId());
        this._countryPreparedStatement.setString(7, this._companyGuestUser.getFullName());
        this._countryPreparedStatement.setDate(8, this._companyDate);
        this._countryPreparedStatement.setDate(9, this._companyDate);
        this._countryPreparedStatement.setString(10, countryJSONObject.getString("a2"));
        this._countryPreparedStatement.setString(11, countryJSONObject.getString("a3"));
        this._countryPreparedStatement.setBoolean(12, true);
        this._countryPreparedStatement.setBoolean(13, true);
        this._countryPreparedStatement.setBoolean(14, false);
        this._countryPreparedStatement.setString(15, countryJSONObject.getString("idd"));
        this._countryPreparedStatement.setString(16, countryJSONObject.getString("name"));
        this._countryPreparedStatement.setString(17, countryJSONObject.getString("number"));
        this._countryPreparedStatement.setDouble(18, 0.0);
        this._countryPreparedStatement.setBoolean(19, true);
        this._countryPreparedStatement.setBoolean(20, false);
        this._countryPreparedStatement.setBoolean(21, countryJSONObject.getBoolean("zipRequired"));
        this._countryPreparedStatement.setDate(22, this._companyDate);
        this._countryPreparedStatement.addBatch();
        for (Locale locale : this._companyAvailableLocales) {
            this._countryLocalizationPreparedStatement.setLong(1, 0L);
            this._countryLocalizationPreparedStatement.setLong(2, this.increment());
            this._countryLocalizationPreparedStatement.setLong(3, company.getCompanyId());
            this._countryLocalizationPreparedStatement.setLong(4, countryId);
            this._countryLocalizationPreparedStatement.setString(5, this._getLanguageId(locale));
            this._countryLocalizationPreparedStatement.setString(6, this._getLocalizedName(locale, countryJSONObject.getString("name")));
            this._countryLocalizationPreparedStatement.addBatch();
        }
        this._processCountryRegions(company, countryJSONObject.getString("a2"), countryId);
    }

    private void _addRegion(Company company, long countryId, JSONObject regionJSONObject) throws Exception {
        long regionId = this.increment(Region.class.getName());
        String regionName = regionJSONObject.getString("name");
        this._regionPreparedStatement.setLong(1, 0L);
        this._regionPreparedStatement.setString(2, PortalUUIDUtil.generate());
        this._regionPreparedStatement.setString(3, UpgradeProcessUtil.getDefaultLanguageId((long)company.getCompanyId()));
        this._regionPreparedStatement.setLong(4, regionId);
        this._regionPreparedStatement.setLong(5, company.getCompanyId());
        this._regionPreparedStatement.setLong(6, this._companyGuestUser.getUserId());
        this._regionPreparedStatement.setString(7, this._companyGuestUser.getFullName());
        this._regionPreparedStatement.setDate(8, this._companyDate);
        this._regionPreparedStatement.setDate(9, this._companyDate);
        this._regionPreparedStatement.setLong(10, countryId);
        this._regionPreparedStatement.setBoolean(11, true);
        this._regionPreparedStatement.setString(12, regionJSONObject.getString("name"));
        this._regionPreparedStatement.setDouble(13, 0.0);
        this._regionPreparedStatement.setString(14, regionJSONObject.getString("regionCode"));
        this._regionPreparedStatement.setDate(15, this._companyDate);
        this._regionPreparedStatement.addBatch();
        JSONObject localizationsJSONObject = regionJSONObject.getJSONObject("localizations");
        HashMap<String, String> titleMap = new HashMap<String, String>();
        if (localizationsJSONObject == null) {
            for (Locale locale : this._companyAvailableLocales) {
                titleMap.put(this._getLanguageId(locale), regionName);
            }
        } else {
            for (String string : localizationsJSONObject.keySet()) {
                titleMap.put(string, localizationsJSONObject.getString(string));
            }
        }
        for (Map.Entry entry : titleMap.entrySet()) {
            this._regionLocalizationPreparedStatement.setLong(1, 0L);
            this._regionLocalizationPreparedStatement.setLong(2, this.increment());
            this._regionLocalizationPreparedStatement.setLong(3, company.getCompanyId());
            this._regionLocalizationPreparedStatement.setLong(4, regionId);
            this._regionLocalizationPreparedStatement.setString(5, (String)entry.getKey());
            this._regionLocalizationPreparedStatement.setString(6, (String)entry.getValue());
            this._regionLocalizationPreparedStatement.addBatch();
        }
    }

    private JSONArray _getJSONArray(String path) throws Exception {
        return JSONFactoryUtil.createJSONArray((String)StringUtil.read((ClassLoader)this._classLoader, (String)path, (boolean)false));
    }

    private String _getLanguageId(Locale locale) {
        return this._localesLanguageIds.computeIfAbsent(locale, key -> LanguageUtil.getLanguageId((Locale)key));
    }

    private String _getLocalizedName(Locale locale, String name) {
        String localizedName = LanguageUtil.get((Locale)locale, (String)("country." + name));
        if (!localizedName.startsWith("country.")) {
            return localizedName;
        }
        return name;
    }

    /*
     * Exception decompiling
     */
    private boolean _hasCountries(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _populateCompanyCountries(Company company) throws Exception {
        if (this._hasCountries(company.getCompanyId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping country initialization. Countries are ", "already initialized for company ", company.getCompanyId(), "."}));
            }
            return;
        }
        this._companyAvailableLocales = LanguageUtil.getCompanyAvailableLocales((long)company.getCompanyId());
        this._companyDate = new Date(System.currentTimeMillis());
        this._companyGuestUser = company.getGuestUser();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing countries for company " + company.getCompanyId()));
        }
        JSONArray countriesJSONArray = this._getJSONArray("com/liferay/address/dependencies/countries.json");
        try (PreparedStatement countryPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into Country (mvccVersion, uuid_, ", "defaultLanguageId, countryId, companyId, userId, ", "userName, createDate, modifiedDate, a2, a3, active_, ", "billingAllowed, groupFilterEnabled, idd_, name, ", "number_, position, shippingAllowed, subjectToVAT, ", "zipRequired, lastPublishDate) values(?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?)"}));
             PreparedStatement countryLocalizationPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into CountryLocalization (mvccVersion, ", "countryLocalizationId, companyId, countryId, ", "languageId, title) values (?, ?, ?, ?, ?, ?)"}));
             PreparedStatement regionPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into Region (mvccVersion, uuid_, ", "defaultLanguageId, regionId, companyId, userId, ", "userName, createDate, modifiedDate, countryId, ", "active_, name, position, regionCode, ", "lastPublishDate) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?)"}));
             PreparedStatement regionLocalizationPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into RegionLocalization (mvccVersion, ", "regionLocalizationId, companyId, regionId, ", "languageId, title) values (?, ?, ?, ?, ?, ?)"}));){
            this._countryPreparedStatement = countryPreparedStatement;
            this._countryLocalizationPreparedStatement = countryLocalizationPreparedStatement;
            this._regionPreparedStatement = regionPreparedStatement;
            this._regionLocalizationPreparedStatement = regionLocalizationPreparedStatement;
            for (int i = 0; i < countriesJSONArray.length(); ++i) {
                JSONObject countryJSONObject = countriesJSONArray.getJSONObject(i);
                this._addCountry(company, countryJSONObject);
            }
            this._countryPreparedStatement.executeBatch();
            this._countryLocalizationPreparedStatement.executeBatch();
            this._regionPreparedStatement.executeBatch();
            this._regionLocalizationPreparedStatement.executeBatch();
        }
    }

    private void _processCountryRegions(Company company, String a2, long countryId) throws Exception {
        String path = "com/liferay/address/dependencies/regions/" + a2 + ".json";
        if (this._classLoader.getResource(path) == null) {
            return;
        }
        JSONArray regionsJSONArray = this._getJSONArray(path);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Regions found for country " + a2));
        }
        for (int i = 0; i < regionsJSONArray.length(); ++i) {
            JSONObject regionJSONObject = regionsJSONArray.getJSONObject(i);
            this._addRegion(company, countryId, regionJSONObject);
        }
    }

    private void _updateRegionCounter() throws Exception {
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select max(regionId) from Region");){
            if (resultSet.next()) {
                this.increment(Region.class.getName(), (int)resultSet.getLong(1));
            }
        }
    }
}

