/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.search.spi.model.query.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.LinkedHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Address"}, service={ModelPreFilterContributor.class})
public class AddressModelPreFilterContributor
implements ModelPreFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(AddressModelPreFilterContributor.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByClass(booleanFilter, searchContext);
        this._filterByListTypeId(booleanFilter, searchContext);
    }

    private void _filterByClass(BooleanFilter booleanFilter, SearchContext searchContext) {
        long classPK;
        long classNameId = GetterUtil.getLong((Object)searchContext.getAttribute("classNameId"));
        if (classNameId > 0L) {
            booleanFilter.addTerm("classNameId", String.valueOf(classNameId), BooleanClauseOccur.MUST);
        }
        if ((classPK = GetterUtil.getLong((Object)searchContext.getAttribute("classPK"), (long)Long.MIN_VALUE)) > Long.MIN_VALUE) {
            booleanFilter.addTerm("classPK", String.valueOf(classPK), BooleanClauseOccur.MUST);
        }
    }

    private void _filterByListTypeId(BooleanFilter booleanFilter, SearchContext searchContext) {
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params == null) {
            return;
        }
        long[] listTypeIds = params.getOrDefault("listTypeIds", new long[0]);
        Object[] typeNames = (String[])params.get("typeNames");
        if (ArrayUtil.isNotEmpty((Object[])typeNames)) {
            listTypeIds = ArrayUtil.unique((long[])ArrayUtil.append((long[][])new long[][]{listTypeIds, this._getTypeIds(searchContext, (String[])typeNames)}));
        }
        if (ArrayUtil.isNotEmpty((long[])listTypeIds)) {
            TermsFilter termsFilter = new TermsFilter("listTypeId");
            termsFilter.addValues(ArrayUtil.toStringArray((long[])listTypeIds));
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
        }
    }

    private long[] _getTypeIds(SearchContext searchContext, String[] typeNames) {
        long classNameId = GetterUtil.getLong((Object)searchContext.getAttribute("classNameId"));
        if (classNameId <= 0L) {
            return new long[0];
        }
        ClassName className = this._classNameLocalService.fetchByClassNameId(classNameId);
        if (className == null) {
            return new long[0];
        }
        long[] typeIds = new long[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            String listTypeType = className.getClassName() + ".address";
            ListType listType = this._listTypeLocalService.getListType(searchContext.getCompanyId(), typeNames[i], listTypeType);
            if (listType == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"No list type found for ", listTypeType, " with the name ", typeNames[i]}));
                }
                typeIds[i] = -1L;
                continue;
            }
            typeIds[i] = listType.getListTypeId();
        }
        return typeIds;
    }
}

