/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Address"}, service={ModelDocumentContributor.class})
public class AddressModelDocumentContributor
implements ModelDocumentContributor<Address> {
    public void contribute(Document document, Address address) {
        document.addText("name", address.getName());
        document.addText("city", address.getCity());
        document.addText("countryName", this._getCountryName(address));
        document.addText("description", address.getDescription());
        document.addKeyword("listTypeId", address.getListTypeId());
        document.addText("regionName", this._getRegionName(address));
        document.addText("street1", address.getStreet1());
        document.addText("zip", address.getZip());
    }

    private String _getCountryName(Address address) {
        Country country = address.getCountry();
        return country.getName();
    }

    private String _getRegionName(Address address) {
        Region region = address.getRegion();
        if (region != null) {
            return region.getName();
        }
        return null;
    }
}

