/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.address.apio.internal.architect.resource;

import com.liferay.address.apio.architect.identifier.AddressIdentifier;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.ItemResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AddressModel;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.RegionModel;
import com.liferay.portal.kernel.service.AddressService;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ItemResource.class})
public class AddressCollectionResource
implements ItemResource<Address, Long, AddressIdentifier> {
    @Reference
    private AddressService _addressService;
    @Reference
    private CountryService _countryService;
    @Reference
    private RegionService _regionService;

    public String getName() {
        return "addresses";
    }

    public ItemRoutes<Address, Long> itemRoutes(ItemRoutes.Builder<Address, Long> builder) {
        return builder.addGetter(arg_0 -> ((AddressService)this._addressService).getAddress(arg_0)).build();
    }

    public Representor<Address> representor(Representor.Builder<Address, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("PostalAddress", new String[0]).identifier(AddressModel::getAddressId).addLocalizedStringByLocale("addressCountry", this::_getCountry)).addString("addressLocality", AddressModel::getCity)).addString("addressRegion", this::_getRegion)).addString("addressType", address -> {
            ListType type = address.getType();
            return type.getName();
        })).addString("postalCode", AddressModel::getZip)).addString("streetAddressLine1", AddressModel::getStreet1)).addString("streetAddressLine2", AddressModel::getStreet2)).addString("streetAddressLine3", AddressModel::getStreet3)).build();
    }

    private String _getCountry(Address address, Locale locale) {
        return (String)Try.success((Object)address.getCountryId()).map(arg_0 -> ((CountryService)this._countryService).getCountry(arg_0)).map(country -> country.getName(locale)).orElse(null);
    }

    private String _getRegion(Address address) {
        return (String)Try.success((Object)address.getRegionId()).map(arg_0 -> ((RegionService)this._regionService).getRegion(arg_0)).map(RegionModel::getName).orElse(null);
    }
}

