/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.web.internal.html;

import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.media.query.Condition;
import com.liferay.adaptive.media.image.media.query.MediaQuery;
import com.liferay.adaptive.media.image.media.query.MediaQueryProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AMImageHTMLTagFactory.class})
public class AMImageHTMLTagFactoryImpl
implements AMImageHTMLTagFactory {
    private MediaQueryProvider _mediaQueryProvider;

    public String create(String originalImgTag, FileEntry fileEntry) throws PortalException {
        List<String> sourceElements = this._getSourceElements(fileEntry);
        if (sourceElements.isEmpty()) {
            return originalImgTag;
        }
        StringBundler sb = new StringBundler(5 + sourceElements.size());
        sb.append("<picture ");
        sb.append("data-fileentryid");
        sb.append("=\"");
        sb.append(fileEntry.getFileEntryId());
        sb.append("\">");
        sourceElements.forEach(arg_0 -> ((StringBundler)sb).append(arg_0));
        sb.append(originalImgTag);
        sb.append("</picture>");
        return sb.toString();
    }

    @Reference(unbind="-")
    protected void setMediaQueryProvider(MediaQueryProvider mediaQueryProvider) {
        this._mediaQueryProvider = mediaQueryProvider;
    }

    private Optional<String> _getMediaQueryString(MediaQuery mediaQuery) {
        List conditions = mediaQuery.getConditions();
        if (conditions.isEmpty()) {
            return Optional.empty();
        }
        CharSequence[] conditionStrings = new String[conditions.size()];
        for (int i = 0; i < conditionStrings.length; ++i) {
            Condition condition = (Condition)conditions.get(i);
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(condition.getAttribute());
            sb.append(":");
            sb.append(condition.getValue());
            sb.append(")");
            conditionStrings[i] = sb.toString();
        }
        return Optional.of(String.join((CharSequence)" and ", conditionStrings));
    }

    private String _getSourceElement(MediaQuery mediaQuery) {
        StringBundler sb = new StringBundler(5);
        Optional<String> mediaQueryStringOptional = this._getMediaQueryString(mediaQuery);
        mediaQueryStringOptional.ifPresent(mediaQueryString -> {
            sb.append("<source media=\"");
            sb.append(mediaQueryString);
            sb.append("\" srcset=\"");
            sb.append(mediaQuery.getSrc());
            sb.append("\" />");
        });
        return sb.toString();
    }

    private List<String> _getSourceElements(FileEntry fileEntry) throws PortalException {
        List mediaQueries = this._mediaQueryProvider.getMediaQueries(fileEntry);
        Stream mediaQueryStream = mediaQueries.stream();
        return mediaQueryStream.map(this::_getSourceElement).collect(Collectors.toList());
    }
}

