/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.item.selector.internal;

import com.liferay.adaptive.media.image.item.selector.AMImageURLItemSelectorReturnType;
import com.liferay.adaptive.media.image.media.query.Condition;
import com.liferay.adaptive.media.image.media.query.MediaQuery;
import com.liferay.adaptive.media.image.media.query.MediaQueryProvider;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.item.selector.ItemSelectorReturnTypeResolver;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.util.RepositoryUtil;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={ItemSelectorReturnTypeResolver.class})
public class FileEntryAMImageURLItemSelectorReturnTypeResolver
implements ItemSelectorReturnTypeResolver<AMImageURLItemSelectorReturnType, FileEntry> {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private MediaQueryProvider _mediaQueryProvider;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public Class<AMImageURLItemSelectorReturnType> getItemSelectorReturnTypeClass() {
        return AMImageURLItemSelectorReturnType.class;
    }

    public Class<FileEntry> getModelClass() {
        return FileEntry.class;
    }

    public String getValue(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        String previewURL = null;
        long repositoryId = fileEntry.getRepositoryId();
        previewURL = RepositoryUtil.isExternalRepository((long)repositoryId) || fileEntry.getGroupId() == repositoryId ? this._dlURLHelper.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay, "", false, false) : this._portletFileRepository.getPortletFileEntryURL(themeDisplay, fileEntry, "&imagePreview=1", false);
        return JSONUtil.put((String)"defaultSource", (Object)previewURL).put("fileEntryId", String.valueOf(fileEntry.getFileEntryId())).put("sources", JSONUtil.toJSONArray((Collection)this._mediaQueryProvider.getMediaQueries(fileEntry), this::_getSourceJSONObject)).toString();
    }

    private JSONObject _getSourceJSONObject(MediaQuery mediaQuery) {
        return JSONUtil.put((String)"attributes", () -> {
            JSONObject attributesJSONObject = this._jsonFactory.createJSONObject();
            for (Condition condition : mediaQuery.getConditions()) {
                attributesJSONObject.put(condition.getAttribute(), condition.getValue());
            }
            return attributesJSONObject;
        }).put("src", mediaQuery.getSrc());
    }
}

