/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.util;

import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.internal.configuration.AMImageAttributeMapping;
import com.liferay.adaptive.media.image.internal.processor.AMImage;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.util.AMImageSerializer;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMImageSerializer.class})
public class AMImageSerializerImpl
implements AMImageSerializer {
    @Reference
    private JSONFactory _jsonFactory;

    public AdaptiveMedia<AMImageProcessor> deserialize(String s, Supplier<InputStream> inputStreamSupplier) {
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(s);
            HashMap<String, String> properties = new HashMap<String, String>();
            JSONObject attributesJSONObject = jsonObject.getJSONObject("attributes");
            Map allowedAMAttributes = AMImageAttribute.getAllowedAMAttributes();
            allowedAMAttributes.forEach((name, amAttribute) -> {
                if (attributesJSONObject.has(name)) {
                    properties.put((String)name, attributesJSONObject.getString(name));
                }
            });
            String uri = jsonObject.getString("uri");
            return new AMImage(inputStreamSupplier, AMImageAttributeMapping.fromProperties(properties), URI.create(uri));
        }
        catch (JSONException jsonException) {
            throw new AMRuntimeException((Throwable)jsonException);
        }
    }

    public String serialize(AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        JSONObject attributesJSONObject = this._jsonFactory.createJSONObject();
        Map allowedAMAttributes = AMImageAttribute.getAllowedAMAttributes();
        allowedAMAttributes.forEach((name, amAttribute) -> {
            Optional valueOptional = adaptiveMedia.getValueOptional(amAttribute);
            valueOptional.ifPresent(value -> attributesJSONObject.put(name, String.valueOf(value)));
        });
        return JSONUtil.put((String)"attributes", (Object)attributesJSONObject).put("uri", (Object)adaptiveMedia.getURI()).toString();
    }
}

