/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.processor;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.adaptive.media.image.scaler.AMImageScalerRegistry;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.adaptive.media.processor.AMProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.FileVersionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.repository.model.FileVersion"}, service={AMImageProcessor.class, AMProcessor.class})
public final class AMImageProcessorImpl
implements AMImageProcessor {
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageScalerRegistry _amImageScalerRegistry;
    @Reference
    private AMImageValidator _amImageValidator;

    public void cleanUp(FileVersion fileVersion) throws PortalException {
        if (!this._amImageValidator.isValid(fileVersion)) {
            return;
        }
        this._amImageEntryLocalService.deleteAMImageEntryFileVersion(fileVersion);
    }

    public void process(FileVersion fileVersion) throws PortalException {
        if (!this._amImageValidator.isProcessingSupported(fileVersion)) {
            return;
        }
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(fileVersion.getCompanyId());
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this.process(fileVersion, amImageConfigurationEntry.getUUID());
        }
    }

    public void process(FileVersion fileVersion, String configurationEntryUuid) throws PortalException {
        if (!this._amImageValidator.isProcessingSupported(fileVersion)) {
            return;
        }
        Optional amImageConfigurationEntryOptional = this._amImageConfigurationHelper.getAMImageConfigurationEntry(fileVersion.getCompanyId(), configurationEntryUuid);
        if (!amImageConfigurationEntryOptional.isPresent()) {
            return;
        }
        AMImageConfigurationEntry amImageConfigurationEntry = (AMImageConfigurationEntry)amImageConfigurationEntryOptional.get();
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), fileVersion.getFileVersionId());
        try {
            AMImageScaler amImageScaler;
            if (!this._isUpdateImageEntry(amImageEntry, fileVersion)) {
                return;
            }
            if (amImageEntry != null) {
                this._amImageEntryLocalService.deleteAMImageEntry(amImageEntry.getAmImageEntryId());
            }
            if ((amImageScaler = this._amImageScalerRegistry.getAMImageScaler(fileVersion.getMimeType())) == null) {
                return;
            }
            AMImageScaledImage amImageScaledImage = amImageScaler.scaleImage(fileVersion, amImageConfigurationEntry);
            try (InputStream inputStream = amImageScaledImage.getInputStream();){
                this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, this._getScaledFileVersion(amImageScaledImage, fileVersion), amImageScaledImage.getHeight(), amImageScaledImage.getWidth(), inputStream, amImageScaledImage.getSize());
            }
        }
        catch (IOException ioException) {
            throw new AMRuntimeException.IOException((Throwable)ioException);
        }
    }

    private FileVersion _getScaledFileVersion(AMImageScaledImage amImageScaledImage, FileVersion fileVersion) {
        final String mimeType = amImageScaledImage.getMimeType();
        if (mimeType == null || !mimeType.equals(fileVersion.getMimeType()) || mimeType.equals("application/octet-stream")) {
            return fileVersion;
        }
        return new FileVersionWrapper(fileVersion){

            public String getMimeType() {
                return mimeType;
            }
        };
    }

    private boolean _isUpdateImageEntry(AMImageEntry amImageEntry, FileVersion fileVersion) throws PortalException {
        if (amImageEntry == null || !this._amImageEntryLocalService.hasAMImageEntryContent(amImageEntry.getConfigurationUuid(), fileVersion)) {
            return true;
        }
        FileEntry fileEntry = fileVersion.getFileEntry();
        Date amImageEntryCreationDate = amImageEntry.getCreateDate();
        return fileEntry.isCheckedOut() || amImageEntryCreationDate.before(fileVersion.getModifiedDate());
    }
}

