/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.validator;

import com.liferay.adaptive.media.image.internal.configuration.AMImageConfiguration;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.adaptive.media.image.internal.configuration.AMImageConfiguration"}, service={AMImageValidator.class})
public class AMImageValidatorImpl
implements AMImageValidator {
    private volatile AMImageConfiguration _amImageConfiguration;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;

    public boolean isValid(FileVersion fileVersion) {
        if (!DLProcessorRegistryUtil.isPreviewableSize((FileVersion)fileVersion)) {
            return false;
        }
        long imageMaxSize = this._amImageConfiguration.imageMaxSize();
        if (imageMaxSize != -1L && (imageMaxSize == 0L || fileVersion.getSize() == 0L || fileVersion.getSize() >= imageMaxSize)) {
            return false;
        }
        return this._amImageMimeTypeProvider.isMimeTypeSupported(fileVersion.getMimeType());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._amImageConfiguration = (AMImageConfiguration)ConfigurableUtil.createConfigurable(AMImageConfiguration.class, properties);
    }
}

