/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.util;

import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.internal.configuration.AMImageAttributeMapping;
import com.liferay.adaptive.media.image.internal.processor.AMImage;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.util.AMImageSerializer;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={AMImageSerializer.class})
public class AMImageSerializerImpl
implements AMImageSerializer {
    public AdaptiveMedia<AMImageProcessor> deserialize(String s, Supplier<InputStream> inputStreamSupplier) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)s);
            HashMap<String, String> properties = new HashMap<String, String>();
            JSONObject attributesJSONObject = jsonObject.getJSONObject("attributes");
            Map allowedAMAttributes = AMImageAttribute.getAllowedAMAttributes();
            allowedAMAttributes.forEach((name, amAttribute) -> {
                if (attributesJSONObject.has(name)) {
                    properties.put((String)name, attributesJSONObject.getString(name));
                }
            });
            String uri = jsonObject.getString("uri");
            return new AMImage(inputStreamSupplier, AMImageAttributeMapping.fromProperties(properties), URI.create(uri));
        }
        catch (JSONException jsone) {
            throw new AMRuntimeException((Throwable)jsone);
        }
    }

    public String serialize(AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject attributesJSONObject = JSONFactoryUtil.createJSONObject();
        Map allowedAMAttributes = AMImageAttribute.getAllowedAMAttributes();
        allowedAMAttributes.forEach((name, amAttribute) -> {
            Optional valueOptional = adaptiveMedia.getValueOptional(amAttribute);
            valueOptional.ifPresent(value -> attributesJSONObject.put(name, String.valueOf(value)));
        });
        jsonObject.put("attributes", attributesJSONObject);
        jsonObject.put("uri", (Object)adaptiveMedia.getURI());
        return jsonObject.toString();
    }
}

