/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.configuration;

import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfigurationEntryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMImageConfigurationEntryParser.class})
public class AMImageConfigurationEntryParser {
    private static final Pattern _attributeSeparatorPattern = Pattern.compile("\\s*;\\s*");
    private static final Pattern _disabledSeparatorPattern = Pattern.compile("enabled=(true|false)");
    private static final Pattern _fieldSeparatorPattern = Pattern.compile("\\s*:\\s*");
    private static final Pattern _keyValueSeparatorPattern = Pattern.compile("\\s*=\\s*");
    @Reference
    private Http _http;

    public AMImageConfigurationEntryParser() {
    }

    public String getConfigurationString(AMImageConfigurationEntry amImageConfigurationEntry) {
        StringBundler sb = new StringBundler(14);
        sb.append(URLCodec.encodeURL((String)amImageConfigurationEntry.getName()));
        sb.append(":");
        sb.append(URLCodec.encodeURL((String)amImageConfigurationEntry.getDescription()));
        sb.append(":");
        sb.append(amImageConfigurationEntry.getUUID());
        sb.append(":");
        Map properties = amImageConfigurationEntry.getProperties();
        if (properties.get("max-height") != null) {
            int height = GetterUtil.getInteger((String)((String)properties.get("max-height")));
            sb.append("max-height=");
            sb.append(height);
            if (properties.get("max-width") != null) {
                sb.append(";");
            }
        }
        if (properties.get("max-width") != null) {
            int width = GetterUtil.getInteger((String)((String)properties.get("max-width")));
            sb.append("max-width=");
            sb.append(width);
        }
        sb.append(":");
        sb.append("enabled=");
        sb.append(String.valueOf(amImageConfigurationEntry.isEnabled()));
        return sb.toString();
    }

    public AMImageConfigurationEntry parse(String s) {
        if (Validator.isNull((String)s)) {
            throw new IllegalArgumentException("Invalid image adaptive media configuration: " + s);
        }
        String[] fields = _fieldSeparatorPattern.split(s);
        if (fields.length != 4 && fields.length != 5) {
            throw new IllegalArgumentException("Invalid image adaptive media configuration: " + s);
        }
        String name = fields[0];
        name = this._http.decodeURL(name);
        String description = fields[1];
        description = this._http.decodeURL(description);
        String uuid = fields[2];
        if (Validator.isNull((String)name) || Validator.isNull((String)uuid)) {
            throw new IllegalArgumentException("Invalid image adaptive media configuration: " + s);
        }
        String[] attributes = _attributeSeparatorPattern.split(fields[3]);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String attribute : attributes) {
            String[] keyValuePair = _keyValueSeparatorPattern.split(attribute);
            properties.put(keyValuePair[0], keyValuePair[1]);
        }
        boolean enabled = true;
        if (fields.length == 5) {
            String disabledAttribute = fields[4];
            Matcher matcher = _disabledSeparatorPattern.matcher(disabledAttribute);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid image adaptive media configuration: " + s);
            }
            enabled = GetterUtil.getBoolean((String)matcher.group(1));
        }
        return new AMImageConfigurationEntryImpl(name, description, uuid, properties, enabled);
    }

    protected AMImageConfigurationEntryParser(Http http) {
        this._http = http;
    }
}

