/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.scaler;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.internal.configuration.AMImageConfiguration;
import com.liferay.adaptive.media.image.internal.scaler.AMImageScaledImageImpl;
import com.liferay.adaptive.media.image.internal.util.RenderedImageUtil;
import com.liferay.adaptive.media.image.internal.util.Tuple;
import com.liferay.adaptive.media.image.scaler.AMImageScaledImage;
import com.liferay.adaptive.media.image.scaler.AMImageScaler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.process.CollectorOutputProcessor;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.adaptive.media.image.internal.configuration.AMImageConfiguration"}, immediate=true, property={"mime.type=image/gif"}, service={AMImageScaler.class})
public class AMGIFImageScaler
implements AMImageScaler {
    private volatile AMImageConfiguration _amImageConfiguration;

    public boolean isEnabled() {
        return this._amImageConfiguration.gifsicleEnabled();
    }

    public AMImageScaledImage scaleImage(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            File file = this._getFile(fileVersion);
            NoticeableFuture future = ProcessUtil.execute((OutputProcessor)new CollectorOutputProcessor(), (String[])new String[]{"gifsicle", "--resize-fit", this.getResizeFitValues(amImageConfigurationEntry), "--output", "-", file.getAbsolutePath()});
            ObjectValuePair objectValuePair = (ObjectValuePair)future.get();
            byte[] bytes = (byte[])objectValuePair.getKey();
            Tuple<Integer, Integer> dimension = this.getDimension(bytes);
            return new AMImageScaledImageImpl(bytes, (Integer)dimension.second, (Integer)dimension.first);
        }
        catch (PortalException | ProcessException | IOException | InterruptedException | ExecutionException e) {
            throw new AMRuntimeException.IOException(e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._amImageConfiguration = (AMImageConfiguration)ConfigurableUtil.createConfigurable(AMImageConfiguration.class, properties);
    }

    protected Tuple<Integer, Integer> getDimension(byte[] bytes) throws IOException {
        try (UnsyncByteArrayInputStream inputStream = new UnsyncByteArrayInputStream(bytes);){
            RenderedImage renderedImage = RenderedImageUtil.readImage((InputStream)inputStream);
            Tuple<Integer, Integer> tuple = Tuple.of(renderedImage.getWidth(), renderedImage.getHeight());
            return tuple;
        }
    }

    protected String getResizeFitValues(AMImageConfigurationEntry amImageConfigurationEntry) {
        Map properties = amImageConfigurationEntry.getProperties();
        int maxHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
        String maxHeightString = "_";
        if (maxHeight != 0) {
            maxHeightString = String.valueOf(maxHeight);
        }
        int maxWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
        String maxWidthString = "_";
        if (maxWidth != 0) {
            maxWidthString = String.valueOf(maxWidth);
        }
        return maxWidthString.concat("x").concat(maxHeightString);
    }

    private File _getFile(FileVersion fileVersion) throws IOException, PortalException {
        if (fileVersion instanceof LiferayFileVersion) {
            LiferayFileVersion liferayFileVersion = (LiferayFileVersion)fileVersion;
            return liferayFileVersion.getFile(false);
        }
        try (InputStream inputStream = fileVersion.getContentStream(false);){
            File file = FileUtil.createTempFile((InputStream)inputStream);
            return file;
        }
    }
}

