/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.handler;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.handler.AMRequestHandler;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.internal.configuration.AMImageAttributeMapping;
import com.liferay.adaptive.media.image.internal.handler.PathInterpreter;
import com.liferay.adaptive.media.image.internal.processor.AMImage;
import com.liferay.adaptive.media.image.internal.util.Tuple;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessorLocator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"adaptive.media.handler.pattern=image"}, service={AMRequestHandler.class})
public class AMImageRequestHandler
implements AMRequestHandler<AMImageProcessor> {
    private static final Log _log = LogFactoryUtil.getLog(AMImageRequestHandler.class);
    private AMAsyncProcessorLocator _amAsyncProcessorLocator;
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    private AMImageFinder _amImageFinder;
    private PathInterpreter _pathInterpreter;

    public Optional<AdaptiveMedia<AMImageProcessor>> handleRequest(HttpServletRequest request) throws IOException, ServletException {
        Optional<Tuple<FileVersion, AMImageAttributeMapping>> interpretedPathOptional = this._interpretPath(request.getPathInfo());
        return interpretedPathOptional.flatMap(tuple -> {
            Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = this._findAdaptiveMedia((FileVersion)tuple.first, (AMImageAttributeMapping)tuple.second);
            adaptiveMediaOptional.ifPresent(adaptiveMedia -> this._processAMImage((AdaptiveMedia<AMImageProcessor>)adaptiveMedia, (FileVersion)tuple.first, (AMImageAttributeMapping)tuple.second));
            return adaptiveMediaOptional;
        });
    }

    @Reference(unbind="-")
    public void setAMAsyncProcessorLocator(AMAsyncProcessorLocator amAsyncProcessorLocator) {
        this._amAsyncProcessorLocator = amAsyncProcessorLocator;
    }

    @Reference(unbind="-")
    public void setAMImageConfigurationHelper(AMImageConfigurationHelper amImageConfigurationHelper) {
        this._amImageConfigurationHelper = amImageConfigurationHelper;
    }

    @Reference(unbind="-")
    public void setAMImageFinder(AMImageFinder amImageFinder) {
        this._amImageFinder = amImageFinder;
    }

    @Reference(unbind="-")
    public void setPathInterpreter(PathInterpreter pathInterpreter) {
        this._pathInterpreter = pathInterpreter;
    }

    private AdaptiveMedia<AMImageProcessor> _createRawAdaptiveMedia(FileVersion fileVersion) throws PortalException {
        HashMap<String, String> properties = new HashMap<String, String>();
        AMAttribute fileNameAMAttribute = AMAttribute.getFileNameAMAttribute();
        properties.put(fileNameAMAttribute.getName(), fileVersion.getFileName());
        AMAttribute contentTypeAMAttribute = AMAttribute.getContentTypeAMAttribute();
        properties.put(contentTypeAMAttribute.getName(), fileVersion.getMimeType());
        AMAttribute contentLengthAMAttribute = AMAttribute.getContentLengthAMAttribute();
        properties.put(contentLengthAMAttribute.getName(), String.valueOf(fileVersion.getSize()));
        return new AMImage(() -> {
            try {
                return fileVersion.getContentStream(false);
            }
            catch (PortalException pe) {
                throw new AMRuntimeException((Throwable)pe);
            }
        }, AMImageAttributeMapping.fromProperties(properties), null);
    }

    private Optional<AdaptiveMedia<AMImageProcessor>> _findAdaptiveMedia(FileVersion fileVersion, AMImageAttributeMapping amImageAttributeMapping) {
        try {
            Optional valueOptional = amImageAttributeMapping.getValueOptional(AMAttribute.getConfigurationUuidAMAttribute());
            Optional amImageConfigurationEntryOptional = valueOptional.flatMap(configurationUuid -> this._amImageConfigurationHelper.getAMImageConfigurationEntry(fileVersion.getCompanyId(), configurationUuid));
            if (!amImageConfigurationEntryOptional.isPresent()) {
                return Optional.empty();
            }
            AMImageConfigurationEntry amImageConfigurationEntry = (AMImageConfigurationEntry)amImageConfigurationEntryOptional.get();
            Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = this._findExactAdaptiveMedia(fileVersion, amImageConfigurationEntry);
            if (adaptiveMediaOptional.isPresent()) {
                return adaptiveMediaOptional;
            }
            adaptiveMediaOptional = this._findClosestAdaptiveMedia(fileVersion, amImageConfigurationEntry);
            if (adaptiveMediaOptional.isPresent()) {
                return adaptiveMediaOptional;
            }
            return Optional.of(this._createRawAdaptiveMedia(fileVersion));
        }
        catch (PortalException pe) {
            throw new AMRuntimeException((Throwable)pe);
        }
    }

    private Optional<AdaptiveMedia<AMImageProcessor>> _findClosestAdaptiveMedia(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) {
        Map properties = amImageConfigurationEntry.getProperties();
        Integer configurationWidth = GetterUtil.getInteger((String)((String)properties.get("max-width")));
        Integer configurationHeight = GetterUtil.getInteger((String)((String)properties.get("max-height")));
        try {
            Stream adaptiveMediaStream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH, (Object)configurationWidth).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT, (Object)configurationHeight).done());
            return adaptiveMediaStream.sorted(this._getComparator(configurationWidth)).findFirst();
        }
        catch (PortalException pe) {
            throw new AMRuntimeException((Throwable)pe);
        }
    }

    private Optional<AdaptiveMedia<AMImageProcessor>> _findExactAdaptiveMedia(FileVersion fileVersion, AMImageConfigurationEntry amImageConfigurationEntry) throws PortalException {
        Stream adaptiveMediaStream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).forConfiguration(amImageConfigurationEntry.getUUID()).done());
        return adaptiveMediaStream.findFirst();
    }

    private Comparator<AdaptiveMedia<AMImageProcessor>> _getComparator(Integer configurationWidth) {
        return Comparator.comparingInt(adaptiveMedia -> this._getDistance(configurationWidth, (AdaptiveMedia<AMImageProcessor>)adaptiveMedia));
    }

    private Integer _getDistance(int width, AdaptiveMedia<AMImageProcessor> adaptiveMedia) {
        Optional imageWidthOptional = adaptiveMedia.getValueOptional(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
        Optional<Integer> distanceOptional = imageWidthOptional.map(imageWidth -> Math.abs(imageWidth - width));
        return distanceOptional.orElse(Integer.MAX_VALUE);
    }

    private Optional<Tuple<FileVersion, AMImageAttributeMapping>> _interpretPath(String pathInfo) {
        try {
            Optional<Tuple<FileVersion, Map<String, String>>> fileVersionPropertiesTupleOptional = this._pathInterpreter.interpretPath(pathInfo);
            if (!fileVersionPropertiesTupleOptional.isPresent()) {
                return Optional.empty();
            }
            Tuple<FileVersion, Map<String, String>> fileVersionMapTuple = fileVersionPropertiesTupleOptional.get();
            FileVersion fileVersion = (FileVersion)fileVersionMapTuple.first;
            if (fileVersion.getStatus() == 8) {
                return Optional.empty();
            }
            Map properties = (Map)fileVersionMapTuple.second;
            AMAttribute contentLengthAMAttribute = AMAttribute.getContentLengthAMAttribute();
            properties.put(contentLengthAMAttribute.getName(), String.valueOf(fileVersion.getSize()));
            AMAttribute contentTypeAMAttribute = AMAttribute.getContentTypeAMAttribute();
            properties.put(contentTypeAMAttribute.getName(), fileVersion.getMimeType());
            AMAttribute fileNameAMAttribute = AMAttribute.getFileNameAMAttribute();
            properties.put(fileNameAMAttribute.getName(), fileVersion.getFileName());
            AMImageAttributeMapping amImageAttributeMapping = AMImageAttributeMapping.fromProperties(properties);
            return Optional.of(Tuple.of(fileVersion, amImageAttributeMapping));
        }
        catch (AMRuntimeException | NumberFormatException e) {
            _log.error(e);
            return Optional.empty();
        }
    }

    private void _processAMImage(AdaptiveMedia<AMImageProcessor> adaptiveMedia, FileVersion fileVersion, AMImageAttributeMapping amImageAttributeMapping) {
        Optional attributeMappingConfigurationUuidOptional;
        Optional adaptiveMediaConfigurationUuidOptional = adaptiveMedia.getValueOptional(AMAttribute.getConfigurationUuidAMAttribute());
        if (adaptiveMediaConfigurationUuidOptional.equals(attributeMappingConfigurationUuidOptional = amImageAttributeMapping.getValueOptional(AMAttribute.getConfigurationUuidAMAttribute()))) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this._amAsyncProcessorLocator.locateForClass(FileVersion.class);
            amAsyncProcessor.triggerProcess((Object)fileVersion, String.valueOf(fileVersion.getFileVersionId()));
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to create lazy adaptive media for file version " + fileVersion.getFileVersionId()), (Throwable)pe);
        }
    }
}

