/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.content.transformer.internal;

import com.liferay.adaptive.media.content.transformer.BaseRegexStringContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerContentType;
import com.liferay.adaptive.media.content.transformer.constants.ContentTransformerContentTypes;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.transformer.content.type=html"}, service={ContentTransformer.class})
public class HtmlContentTransformerImpl
extends BaseRegexStringContentTransformer {
    private static final Pattern _pattern = Pattern.compile("<img [^>]*?\\s*data-fileentryid=\"(\\d+)\".*?/>", 34);
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    private DLAppLocalService _dlAppLocalService;

    public ContentTransformerContentType<String> getContentTransformerContentType() {
        return ContentTransformerContentTypes.HTML;
    }

    public String transform(String html) throws PortalException {
        if (html == null) {
            return null;
        }
        if (!html.contains("data-fileentryid")) {
            return html;
        }
        return super.transform(html);
    }

    protected FileEntry getFileEntry(Matcher matcher) throws PortalException {
        long fileEntryId = Long.valueOf(matcher.group(1));
        return this._dlAppLocalService.getFileEntry(fileEntryId);
    }

    protected Pattern getPattern() {
        return _pattern;
    }

    protected String getReplacement(String originalImgTag, FileEntry fileEntry) throws PortalException {
        return this._amImageHTMLTagFactory.create(originalImgTag, fileEntry);
    }

    @Reference(unbind="-")
    protected void setAMImageHTMLTagFactory(AMImageHTMLTagFactory amImageHTMLTagFactory) {
        this._amImageHTMLTagFactory = amImageHTMLTagFactory;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

