/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.optimizer;

import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.optimizer.AMImageOptimizer;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.adaptive.media.processor.AMProcessor;
import com.liferay.document.library.configuration.DLFileEntryConfigurationProvider;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAMImageOptimizer
implements AMImageOptimizer {
    @Reference
    protected AMImageConfigurationHelper amImageConfigurationHelper;
    @Reference
    protected AMImageMimeTypeProvider amImageMimeTypeProvider;
    @Reference
    protected AMImageValidator amImageValidator;
    @Reference
    protected AMProcessor<FileVersion> amProcessor;
    @Reference
    protected BackgroundTaskStatusMessageSender backgroundTaskStatusMessageSender;
    @Reference
    protected DLFileEntryConfigurationProvider dlFileEntryConfigurationProvider;
    private static final Log _log = LogFactoryUtil.getLog(BaseAMImageOptimizer.class);

    @Override
    public void optimize(long companyId) {
        long previewableProcessorMaxSize = this.dlFileEntryConfigurationProvider.getCompanyPreviewableProcessorMaxSize(companyId);
        if (previewableProcessorMaxSize == 0L) {
            return;
        }
        Collection<AMImageConfigurationEntry> amImageConfigurationEntries = this.amImageConfigurationHelper.getAMImageConfigurationEntries(companyId);
        int count = this.countExpectedAMImageEntries(companyId);
        if (count == 0) {
            return;
        }
        int total = count * amImageConfigurationEntries.size();
        AtomicInteger successCounter = new AtomicInteger(0);
        AtomicInteger errorCounter = new AtomicInteger(0);
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this._optimize(companyId, amImageConfigurationEntry.getUUID(), total, successCounter, errorCounter);
        }
    }

    @Override
    public void optimize(long companyId, String configurationEntryUuid) {
        long previewableProcessorMaxSize = this.dlFileEntryConfigurationProvider.getCompanyPreviewableProcessorMaxSize(companyId);
        if (previewableProcessorMaxSize == 0L) {
            return;
        }
        int total = this.countExpectedAMImageEntries(companyId);
        if (total == 0) {
            return;
        }
        AtomicInteger successCounter = new AtomicInteger(0);
        AtomicInteger errorCounter = new AtomicInteger(0);
        this._optimize(companyId, configurationEntryUuid, total, successCounter, errorCounter);
    }

    protected abstract int countExpectedAMImageEntries(long var1);

    protected abstract void forEachFileEntry(long var1, Consumer<DLFileEntry> var3) throws PortalException;

    protected String[] getMimeTypes() {
        return (String[])ArrayUtil.filter((Object[])this.amImageMimeTypeProvider.getSupportedMimeTypes(), this.amImageValidator::isProcessingSupported);
    }

    private Consumer<DLFileEntry> _getProcessDLFileEntryConsumer(String configurationEntryUuid, int total, AtomicInteger successCounter, AtomicInteger errorCounter) {
        Map groupPreviewableProcessorMaxSizeMap = this.dlFileEntryConfigurationProvider.getGroupPreviewableProcessorMaxSizeMap();
        return dlFileEntry -> {
            Long previewableProcessorMaxSize = (Long)groupPreviewableProcessorMaxSizeMap.get(dlFileEntry.getGroupId());
            if (previewableProcessorMaxSize == null || previewableProcessorMaxSize == -1L || dlFileEntry.getSize() <= previewableProcessorMaxSize) {
                this._processDLFileEntry(configurationEntryUuid, total, successCounter, errorCounter, (DLFileEntry)dlFileEntry);
            }
        };
    }

    private void _optimize(long companyId, String configurationEntryUuid, int total, AtomicInteger successCounter, AtomicInteger errorCounter) {
        try {
            this.forEachFileEntry(companyId, this._getProcessDLFileEntryConsumer(configurationEntryUuid, total, successCounter, errorCounter));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _processDLFileEntry(String configurationEntryUuid, int total, AtomicInteger successCounter, AtomicInteger errorCounter, DLFileEntry dlFileEntry) {
        LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
        try {
            this.amProcessor.process(fileEntry.getFileVersion(), configurationEntryUuid);
            this._sendStatusMessage(successCounter.incrementAndGet(), errorCounter.get(), total);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to process file entry " + fileEntry.getFileEntryId()), (Throwable)exception);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            this._sendStatusMessage(successCounter.get(), errorCounter.incrementAndGet(), total);
        }
    }

    private void _sendStatusMessage(int count, int errors, int total) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        Class<?> clazz = this.getClass();
        message.put("className", (Object)clazz.getName());
        message.put("count", (Object)count);
        message.put("errors", (Object)errors);
        message.put("total", (Object)total);
        message.put("status", (Object)1);
        this.backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }
}

