/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.counter;

import com.liferay.adaptive.media.image.counter.AMImageCounter;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.document.library.configuration.DLFileEntryConfigurationProvider;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAMImageCounter
implements AMImageCounter {
    @Reference
    protected AMImageMimeTypeProvider amImageMimeTypeProvider;
    @Reference
    protected AMImageValidator amImageValidator;
    @Reference
    protected DLFileEntryConfigurationProvider dlFileEntryConfigurationProvider;
    private static final Log _log = LogFactoryUtil.getLog(BaseAMImageCounter.class);

    @Override
    public int countExpectedAMImageEntries(long companyId) {
        long previewableProcessorMaxSize = this.dlFileEntryConfigurationProvider.getCompanyPreviewableProcessorMaxSize(companyId);
        if (previewableProcessorMaxSize == 0L) {
            return 0;
        }
        AtomicInteger counter = new AtomicInteger(0);
        try {
            this.forEachFileEntry(companyId, this._getCountDLFileEntryConsumer(counter));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return 0;
        }
        return counter.get();
    }

    protected abstract void forEachFileEntry(long var1, Consumer<DLFileEntry> var3) throws PortalException;

    protected String[] getMimeTypes() {
        return (String[])ArrayUtil.filter((Object[])this.amImageMimeTypeProvider.getSupportedMimeTypes(), this.amImageValidator::isProcessingSupported);
    }

    private Consumer<DLFileEntry> _getCountDLFileEntryConsumer(AtomicInteger counter) {
        Map groupPreviewableProcessorMaxSizeMap = this.dlFileEntryConfigurationProvider.getGroupPreviewableProcessorMaxSizeMap();
        return dlFileEntry -> {
            Long previewableProcessorMaxSize = (Long)groupPreviewableProcessorMaxSizeMap.get(dlFileEntry.getGroupId());
            if (previewableProcessorMaxSize == null || previewableProcessorMaxSize == -1L || dlFileEntry.getSize() <= previewableProcessorMaxSize) {
                counter.incrementAndGet();
            }
        };
    }
}

