/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.internal.repository.registry;

import com.liferay.adaptive.media.processor.AMAsyncProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessorLocator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalogUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseOverridingRepositoryDefiner
implements RepositoryDefiner {
    private AMAsyncProcessorLocator _amAsyncProcessorLocator;
    private RepositoryDefiner _overridenRepositoryDefiner;

    public String getClassName() {
        return this._overridenRepositoryDefiner.getClassName();
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this._overridenRepositoryDefiner.getRepositoryConfiguration();
    }

    public String getRepositoryTypeLabel(Locale locale) {
        return this._overridenRepositoryDefiner.getRepositoryTypeLabel(locale);
    }

    public boolean isExternalRepository() {
        return this._overridenRepositoryDefiner.isExternalRepository();
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        this._overridenRepositoryDefiner.registerCapabilities(capabilityRegistry);
        capabilityRegistry.addSupportedCapability(AdaptiveMediaCapabiliy.class, (Capability)new AdaptiveMediaCapabiliy());
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        this._overridenRepositoryDefiner.registerRepositoryEventListeners(repositoryEventRegistry);
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        this._overridenRepositoryDefiner.registerRepositoryFactory(repositoryFactoryRegistry);
    }

    @Reference(unbind="-")
    public void setAMAsyncProcessorLocator(AMAsyncProcessorLocator amAsyncProcessorLocator) {
        this._amAsyncProcessorLocator = amAsyncProcessorLocator;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    public void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    protected void initializeOverridenRepositoryDefiner(String className) {
        List repositoryDefiners = (List)this._getFieldValue("_repositoryDefiners");
        Stream repositoryDefinerStream = repositoryDefiners.stream();
        Optional<RepositoryDefiner> repositoryDefinerOptional = repositoryDefinerStream.filter(repositoryDefiner -> className.equals(repositoryDefiner.getClassName())).findFirst();
        this._overridenRepositoryDefiner = repositoryDefinerOptional.orElseThrow(() -> new RepositoryException("No repository found with class name " + className));
    }

    protected void restoreOverridenRepositoryDefiner(String className) {
        Map repositoryClassDefinitions = (Map)this._getFieldValue("_repositoryClassDefinitions");
        RepositoryClassDefinition repositoryClassDefinition = RepositoryClassDefinition.fromRepositoryDefiner((RepositoryDefiner)this._overridenRepositoryDefiner);
        repositoryClassDefinitions.put(className, repositoryClassDefinition);
    }

    private void _deleteAdaptiveMedia(FileEntry fileEntry) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this._amAsyncProcessorLocator.locateForClass(FileVersion.class);
            List fileVersions = fileEntry.getFileVersions(-1);
            for (FileVersion fileVersion : fileVersions) {
                amAsyncProcessor.triggerCleanUp((Object)fileVersion, String.valueOf(fileVersion.getFileVersionId()));
            }
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    private <T> T _getFieldValue(String fieldName) {
        try {
            RepositoryClassDefinitionCatalog repositoryClassDefinitionCatalog = RepositoryClassDefinitionCatalogUtil.getRepositoryClassDefinitionCatalog();
            Class<?> clazz = repositoryClassDefinitionCatalog.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(repositoryClassDefinitionCatalog);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void _updateAdaptiveMedia(FileEntry fileEntry) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this._amAsyncProcessorLocator.locateForClass(FileVersion.class);
            FileVersion latestFileVersion = fileEntry.getLatestFileVersion(true);
            amAsyncProcessor.triggerProcess((Object)latestFileVersion, String.valueOf(latestFileVersion.getFileVersionId()));
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    private class AdaptiveMediaCapabiliy
    implements Capability,
    RepositoryEventAware {
        private AdaptiveMediaCapabiliy() {
        }

        public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
            repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Add.class, FileEntry.class, x$0 -> BaseOverridingRepositoryDefiner.this._updateAdaptiveMedia(x$0));
            repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, x$0 -> BaseOverridingRepositoryDefiner.this._deleteAdaptiveMedia(x$0));
            repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, FileEntry.class, x$0 -> BaseOverridingRepositoryDefiner.this._updateAdaptiveMedia(x$0));
        }
    }
}

