/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.internal.document.library.exportimport.data.handler;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntrySerializer;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.model.AMImageEntry;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.service.AMImageEntryLocalService;
import com.liferay.adaptive.media.image.util.AMImageSerializer;
import com.liferay.document.library.exportimport.data.handler.DLPluggableContentDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.repository.model.FileEntry"}, service={DLPluggableContentDataHandler.class})
public class AMImageDLPluggableContentDataHandler
implements DLPluggableContentDataHandler<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AMImageDLPluggableContentDataHandler.class);
    @Reference
    private AMImageConfigurationEntrySerializer _amImageConfigurationEntrySerializer;
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private AMImageEntryLocalService _amImageEntryLocalService;
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageSerializer _amImageSerializer;

    public void exportContent(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(portletDataContext.getCompanyId());
        amImageConfigurationEntries.forEach(amImageConfigurationEntry -> this._exportConfigurationEntry(portletDataContext, (AMImageConfigurationEntry)amImageConfigurationEntry));
        this._exportMedia(portletDataContext, fileEntry);
    }

    public void importContent(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry, FileEntry importedFileEntry) throws Exception {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(portletDataContext.getCompanyId());
        for (AMImageConfigurationEntry amImageConfigurationEntry : amImageConfigurationEntries) {
            this._importGeneratedMedia(portletDataContext, fileEntry, importedFileEntry, amImageConfigurationEntry);
        }
    }

    private void _exportConfigurationEntry(PortletDataContext portletDataContext, AMImageConfigurationEntry amImageConfigurationEntry) {
        portletDataContext.addZipEntry(this._getConfigurationEntryBinPath(amImageConfigurationEntry), this._amImageConfigurationEntrySerializer.serialize(amImageConfigurationEntry));
    }

    private void _exportMedia(PortletDataContext portletDataContext, FileEntry fileEntry) throws IOException, PortalException {
        FileVersion fileVersion = fileEntry.getFileVersion();
        Stream adaptiveMediaStream = this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).done());
        List adaptiveMediaList = adaptiveMediaStream.collect(Collectors.toList());
        for (AdaptiveMedia adaptiveMedia : adaptiveMediaList) {
            this._exportMedia(portletDataContext, fileEntry, (AdaptiveMedia<AMImageProcessor>)adaptiveMedia);
        }
    }

    private void _exportMedia(PortletDataContext portletDataContext, FileEntry fileEntry, AdaptiveMedia<AMImageProcessor> adaptiveMedia) throws IOException {
        Optional configurationUuidOptional = adaptiveMedia.getValueOptional(AMAttribute.getConfigurationUuidAMAttribute());
        if (!configurationUuidOptional.isPresent()) {
            return;
        }
        String basePath = this._getAMBasePath(fileEntry, (String)configurationUuidOptional.get());
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            try (InputStream inputStream = adaptiveMedia.getInputStream();){
                portletDataContext.addZipEntry(basePath + ".bin", inputStream);
            }
        }
        portletDataContext.addZipEntry(basePath + ".json", this._amImageSerializer.serialize(adaptiveMedia));
    }

    private Stream<AdaptiveMedia<AMImageProcessor>> _getAdaptiveMediaStream(FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        try {
            FileVersion fileVersion = fileEntry.getFileVersion();
            return this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).forConfiguration(amImageConfigurationEntry.getUUID()).done());
        }
        catch (PortalException pe) {
            StringBundler sb = new StringBundler(4);
            sb.append("Unable to find adaptive media for file entry ");
            sb.append(fileEntry.getFileEntryId());
            sb.append(" and configuration ");
            sb.append(amImageConfigurationEntry.getUUID());
            _log.error((Object)sb.toString(), (Throwable)pe);
            return Stream.empty();
        }
    }

    private String _getAMBasePath(FileEntry fileEntry, String uuid) {
        return String.format("adaptive-media/%s/%s/%s", FileEntry.class.getSimpleName(), fileEntry.getUuid(), uuid);
    }

    private String _getConfigurationEntryBinPath(AMImageConfigurationEntry amImageConfigurationEntry) {
        return String.format("adaptive-media/%s.cf", amImageConfigurationEntry.getUUID());
    }

    private AdaptiveMedia<AMImageProcessor> _getExportedMedia(PortletDataContext portletDataContext, FileEntry fileEntry, AMImageConfigurationEntry amImageConfigurationEntry) {
        String basePath = this._getAMBasePath(fileEntry, amImageConfigurationEntry.getUUID());
        String serializedAdaptiveMedia = portletDataContext.getZipEntryAsString(basePath + ".json");
        if (serializedAdaptiveMedia == null) {
            return null;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            return this._amImageSerializer.deserialize(serializedAdaptiveMedia, () -> portletDataContext.getZipEntryAsInputStream(basePath + ".bin"));
        }
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getAdaptiveMediaStream(fileEntry, amImageConfigurationEntry);
        Optional<AdaptiveMedia<AMImageProcessor>> firstAdaptiveMediaOptional = adaptiveMediaStream.findFirst();
        return firstAdaptiveMediaOptional.map(adaptiveMedia -> this._amImageSerializer.deserialize(serializedAdaptiveMedia, () -> adaptiveMedia.getInputStream())).orElse(null);
    }

    private void _importGeneratedMedia(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, AMImageConfigurationEntry amImageConfigurationEntry) throws IOException, PortalException {
        String configuration = portletDataContext.getZipEntryAsString(this._getConfigurationEntryBinPath(amImageConfigurationEntry));
        if (configuration == null) {
            return;
        }
        AMImageConfigurationEntry importedAMImageConfigurationEntry = this._amImageConfigurationEntrySerializer.deserialize(configuration);
        if (!importedAMImageConfigurationEntry.equals(amImageConfigurationEntry)) {
            return;
        }
        AdaptiveMedia<AMImageProcessor> adaptiveMedia = this._getExportedMedia(portletDataContext, fileEntry, amImageConfigurationEntry);
        if (adaptiveMedia == null) {
            return;
        }
        Optional contentLengthOptional = adaptiveMedia.getValueOptional(AMAttribute.getContentLengthAMAttribute());
        Optional widthOptional = adaptiveMedia.getValueOptional(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH);
        Optional heightOptional = adaptiveMedia.getValueOptional(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT);
        if (!(contentLengthOptional.isPresent() && widthOptional.isPresent() && heightOptional.isPresent())) {
            return;
        }
        FileVersion importedFileVersion = importedFileEntry.getFileVersion();
        AMImageEntry amImageEntry = this._amImageEntryLocalService.fetchAMImageEntry(amImageConfigurationEntry.getUUID(), importedFileVersion.getFileVersionId());
        if (amImageEntry != null) {
            this._amImageEntryLocalService.deleteAMImageEntryFileVersion(amImageConfigurationEntry.getUUID(), importedFileVersion.getFileVersionId());
        }
        try (InputStream inputStream = adaptiveMedia.getInputStream();){
            this._amImageEntryLocalService.addAMImageEntry(amImageConfigurationEntry, importedFileVersion, ((Integer)heightOptional.get()).intValue(), ((Integer)widthOptional.get()).intValue(), inputStream, ((Long)contentLengthOptional.get()).longValue());
        }
    }
}

