/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.processor;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.document.library.thumbnails.internal.configuration.AMSystemImagesConfiguration;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.adaptive.media.processor.AMAsyncProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessorLocator;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.ImageProcessor;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntryWrapper;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.FileVersionWrapper;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.util.ImageProcessorImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.adaptive.media.document.library.thumbnails.internal.configuration.AMSystemImagesConfiguration"}, immediate=true, property={"service.ranking:Integer=100", "type=ImageProcessor"}, service={AMImageEntryProcessor.class, DLProcessor.class})
public class AMImageEntryProcessor
implements DLProcessor,
ImageProcessor {
    private static final int _THUMBNAIL_INDEX_CUSTOM_1 = 1;
    private static final int _THUMBNAIL_INDEX_CUSTOM_2 = 2;
    private static final Log _log = LogFactoryUtil.getLog(AMImageEntryProcessor.class);
    @Reference
    private AMAsyncProcessorLocator _amAsyncProcessorLocator;
    @Reference
    private AMImageFinder _amImageFinder;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private AMImageValidator _amImageValidator;
    private AMSystemImagesConfiguration _amSystemImagesConfiguration;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private ImageProcessor _imageProcessor;
    @Reference
    private InputStreamSanitizer _inputStreamSanitizer;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this.afterPropertiesSet();
        this._amSystemImagesConfiguration = (AMSystemImagesConfiguration)ConfigurableUtil.createConfigurable(AMSystemImagesConfiguration.class, properties);
    }

    public void afterPropertiesSet() {
        this._imageProcessor = new ImageProcessorImpl();
    }

    public void cleanUp(FileEntry fileEntry) {
    }

    public void cleanUp(FileVersion fileVersion) {
    }

    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    public Set<String> getImageMimeTypes() {
        return new HashSet<String>(Arrays.asList(this._amImageMimeTypeProvider.getSupportedMimeTypes()));
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getAdaptiveMediaStream(fileVersion, this._amSystemImagesConfiguration.previewAMConfiguration(), PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.height"));
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
            return fileVersion.getContentStream(false);
        }
        AdaptiveMedia<AMImageProcessor> adaptiveMedia = adaptiveMediaOptional.get();
        return adaptiveMedia.getInputStream();
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getAdaptiveMediaStream(fileVersion, this._amSystemImagesConfiguration.previewAMConfiguration(), PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.preview.document.max.height"));
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
        }
        return adaptiveMediaOptional.flatMap(mediaMedia -> mediaMedia.getValueOptional(AMAttribute.getContentLengthAMAttribute())).orElse(0L);
    }

    public String getPreviewType(FileVersion fileVersion) {
        return this._imageProcessor.getPreviewType(fileVersion);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion, index);
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
        }
        return adaptiveMediaOptional.map(AdaptiveMedia::getInputStream).orElse(new ByteArrayInputStream(new byte[0]));
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion, index);
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
        }
        return adaptiveMediaOptional.flatMap(mediaMedia -> mediaMedia.getValueOptional(AMAttribute.getContentLengthAMAttribute())).orElse(0L);
    }

    public String getThumbnailType(FileVersion fileVersion) {
        return this._imageProcessor.getThumbnailType(fileVersion);
    }

    public String getType() {
        return "ImageProcessor";
    }

    public boolean hasImages(FileVersion fileVersion) {
        try {
            Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion);
            Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
            if (adaptiveMediaOptional.isPresent()) {
                return true;
            }
            this._processAMImage(fileVersion);
            return false;
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return false;
        }
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    public boolean isImageSupported(FileVersion fileVersion) {
        return this._amImageValidator.isValid(fileVersion);
    }

    public boolean isImageSupported(String mimeType) {
        return this._isMimeTypeSupported(mimeType);
    }

    public boolean isSupported(FileVersion fileVersion) {
        return this._amImageValidator.isValid(fileVersion);
    }

    public boolean isSupported(String mimeType) {
        return this._isMimeTypeSupported(mimeType);
    }

    public void storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) {
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    private Stream<AdaptiveMedia<AMImageProcessor>> _getAdaptiveMediaStream(FileVersion fileVersion, String configurationUuid, int defaultWidth, int defaultHeight) throws PortalException {
        if (Validator.isNotNull((String)configurationUuid)) {
            return this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).forConfiguration(configurationUuid).done());
        }
        return this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH, (Object)defaultWidth).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT, (Object)defaultHeight).done());
    }

    private Stream<AdaptiveMedia<AMImageProcessor>> _getThumbnailAdaptiveMedia(FileVersion fileVersion) throws PortalException {
        return this._getThumbnailAdaptiveMedia(fileVersion, 0);
    }

    private Stream<AdaptiveMedia<AMImageProcessor>> _getThumbnailAdaptiveMedia(FileVersion fileVersion, int index) throws PortalException {
        if (index == 1) {
            return this._getAdaptiveMediaStream(fileVersion, this._amSystemImagesConfiguration.thumbnailCustom1AMConfiguration(), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height"));
        }
        if (index == 2) {
            return this._getAdaptiveMediaStream(fileVersion, this._amSystemImagesConfiguration.thumbnailCustom2AMConfiguration(), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height"));
        }
        return this._getAdaptiveMediaStream(fileVersion, this._amSystemImagesConfiguration.thumbnailAMConfiguration(), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width"), PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height"));
    }

    private boolean _isMimeTypeSupported(String mimeType) {
        return this._amImageMimeTypeProvider.isMimeTypeSupported(mimeType);
    }

    private void _processAMImage(FileVersion fileVersion) {
        if (!this._amImageValidator.isValid(fileVersion)) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this._amAsyncProcessorLocator.locateForClass(FileVersion.class);
            amAsyncProcessor.triggerProcess((Object)new SafeFileVersion(fileVersion), String.valueOf(fileVersion.getFileVersionId()));
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to create lazy adaptive media for file version " + fileVersion.getFileVersionId()), (Throwable)portalException);
        }
    }

    private class SafeFileVersion
    extends FileVersionWrapper {
        public SafeFileVersion(FileVersion fileVersion) {
            super(fileVersion);
        }

        public InputStream getContentStream(boolean incrementCounter) throws PortalException {
            return AMImageEntryProcessor.this._inputStreamSanitizer.sanitize(super.getContentStream(incrementCounter));
        }

        public FileEntry getFileEntry() throws PortalException {
            return new SafeFileEntry(super.getFileEntry());
        }
    }

    private class SafeFileEntry
    extends FileEntryWrapper {
        public SafeFileEntry(FileEntry fileEntry) {
            super(fileEntry);
        }

        public InputStream getContentStream() throws PortalException {
            return AMImageEntryProcessor.this._inputStreamSanitizer.sanitize(super.getContentStream());
        }

        public InputStream getContentStream(String version) throws PortalException {
            return AMImageEntryProcessor.this._inputStreamSanitizer.sanitize(super.getContentStream(version));
        }

        public FileVersion getFileVersion() throws PortalException {
            return new SafeFileVersion(super.getFileVersion());
        }

        public FileVersion getFileVersion(String version) throws PortalException {
            return new SafeFileVersion(super.getFileVersion(version));
        }

        public FileVersion getLatestFileVersion() throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion());
        }

        public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
            return new SafeFileVersion(super.getLatestFileVersion(trusted));
        }
    }
}

