/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.util;

import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.IOException;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AMCompanyThumbnailConfigurationInitializer.class})
public class AMCompanyThumbnailConfigurationInitializer {
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;

    public void initializeCompany(Company company) throws AMImageConfigurationException, IOException {
        int dlFileEntryThumbnailMaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height");
        int dlFileEntryThumbnailMaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width");
        if (dlFileEntryThumbnailMaxHeight > 0 && dlFileEntryThumbnailMaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailMaxHeight, dlFileEntryThumbnailMaxWidth);
        }
        int dlFileEntryThumbnailCustom1MaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.height");
        int dlFileEntryThumbnailCustom1MaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom1.max.width");
        if (dlFileEntryThumbnailCustom1MaxHeight > 0 && dlFileEntryThumbnailCustom1MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom1MaxHeight, dlFileEntryThumbnailCustom1MaxWidth);
        }
        int dlFileEntryThumbnailCustom2MaxHeight = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.height");
        int dlFileEntryThumbnailCustom2MaxWidth = PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.custom2.max.width");
        if (dlFileEntryThumbnailCustom2MaxHeight > 0 && dlFileEntryThumbnailCustom2MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom2MaxHeight, dlFileEntryThumbnailCustom2MaxWidth);
        }
    }

    private void _createAMDocumentLibraryThumbnailConfiguration(Company company, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String name = String.format("%s %dx%d", "Thumbnail", maxWidth, maxHeight);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("max-height", String.valueOf(maxHeight));
        properties.put("max-width", String.valueOf(maxWidth));
        this._amImageConfigurationHelper.addAMImageConfigurationEntry(company.getCompanyId(), name, "This image resolution was automatically added.", name, properties);
    }
}

