/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.processor;

import com.liferay.adaptive.media.AMAttribute;
import com.liferay.adaptive.media.AdaptiveMedia;
import com.liferay.adaptive.media.image.finder.AMImageFinder;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.adaptive.media.image.processor.AMImageAttribute;
import com.liferay.adaptive.media.image.processor.AMImageProcessor;
import com.liferay.adaptive.media.image.validator.AMImageValidator;
import com.liferay.adaptive.media.processor.AMAsyncProcessor;
import com.liferay.adaptive.media.processor.AMAsyncProcessorLocator;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.ImageProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.util.ImageProcessorImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={AMImageEntryProcessor.class, DLProcessor.class})
public class AMImageEntryProcessor
implements DLProcessor,
ImageProcessor {
    private static final Log _log = LogFactoryUtil.getLog(AMImageEntryProcessor.class);
    private AMAsyncProcessorLocator _amAsyncProcessorLocator;
    private AMImageFinder _amImageFinder;
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    private AMImageValidator _amImageValidator;
    private final ImageProcessor _imageProcessor = new ImageProcessorImpl();

    public void afterPropertiesSet() throws Exception {
    }

    public void cleanUp(FileEntry fileEntry) {
    }

    public void cleanUp(FileVersion fileVersion) {
    }

    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
    }

    public Set<String> getImageMimeTypes() {
        return new HashSet<String>(Arrays.asList(this._amImageMimeTypeProvider.getSupportedMimeTypes()));
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion) throws Exception {
        return this._imageProcessor.getPreviewAsStream(fileVersion);
    }

    public long getPreviewFileSize(FileVersion fileVersion) throws Exception {
        return this._imageProcessor.getPreviewFileSize(fileVersion);
    }

    public String getPreviewType(FileVersion fileVersion) {
        return this._imageProcessor.getPreviewType(fileVersion);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion);
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
        }
        return adaptiveMediaOptional.map(AdaptiveMedia::getInputStream).orElse(new ByteArrayInputStream(new byte[0]));
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion);
        Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
        if (!adaptiveMediaOptional.isPresent()) {
            this._processAMImage(fileVersion);
        }
        return adaptiveMediaOptional.flatMap(mediaMedia -> mediaMedia.getValueOptional(AMAttribute.getContentLengthAMAttribute())).orElse(0L);
    }

    public String getThumbnailType(FileVersion fileVersion) {
        return this._imageProcessor.getThumbnailType(fileVersion);
    }

    public String getType() {
        return "ImageProcessor";
    }

    public boolean hasImages(FileVersion fileVersion) {
        try {
            Stream<AdaptiveMedia<AMImageProcessor>> adaptiveMediaStream = this._getThumbnailAdaptiveMedia(fileVersion);
            Optional<AdaptiveMedia<AMImageProcessor>> adaptiveMediaOptional = adaptiveMediaStream.findFirst();
            if (adaptiveMediaOptional.isPresent()) {
                return true;
            }
            this._processAMImage(fileVersion);
            return false;
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
    }

    public boolean isImageSupported(FileVersion fileVersion) {
        return this._amImageValidator.isValid(fileVersion);
    }

    public boolean isImageSupported(String mimeType) {
        return this._isMimeTypeSupported(mimeType);
    }

    public boolean isSupported(FileVersion fileVersion) {
        return this._amImageValidator.isValid(fileVersion);
    }

    public boolean isSupported(String mimeType) {
        return this._isMimeTypeSupported(mimeType);
    }

    @Reference(unbind="-")
    public void setAMAsyncProcessorLocator(AMAsyncProcessorLocator amAsyncProcessorLocator) {
        this._amAsyncProcessorLocator = amAsyncProcessorLocator;
    }

    @Reference(unbind="-")
    public void setAMImageFinder(AMImageFinder amImageFinder) {
        this._amImageFinder = amImageFinder;
    }

    @Reference(unbind="-")
    public void setAMImageMimeTypeProvider(AMImageMimeTypeProvider amImageMimeTypeProvider) {
        this._amImageMimeTypeProvider = amImageMimeTypeProvider;
    }

    @Reference(unbind="-")
    public void setAMImageValidator(AMImageValidator amImageValidator) {
        this._amImageValidator = amImageValidator;
    }

    public void storeThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long custom1ImageId, long custom2ImageId, InputStream is, String type) throws Exception {
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    private Stream<AdaptiveMedia<AMImageProcessor>> _getThumbnailAdaptiveMedia(FileVersion fileVersion) throws PortalException {
        return this._amImageFinder.getAdaptiveMediaStream(amImageQueryBuilder -> amImageQueryBuilder.forFileVersion(fileVersion).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_WIDTH, (Object)PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.width")).with(AMImageAttribute.AM_IMAGE_ATTRIBUTE_HEIGHT, (Object)PrefsPropsUtil.getInteger((String)"dl.file.entry.thumbnail.max.height")).done());
    }

    private boolean _isMimeTypeSupported(String mimeType) {
        return this._amImageMimeTypeProvider.isMimeTypeSupported(mimeType);
    }

    private void _processAMImage(FileVersion fileVersion) {
        if (!this._amImageValidator.isValid(fileVersion)) {
            return;
        }
        try {
            AMAsyncProcessor amAsyncProcessor = this._amAsyncProcessorLocator.locateForClass(FileVersion.class);
            amAsyncProcessor.triggerProcess((Object)fileVersion, String.valueOf(fileVersion.getFileVersionId()));
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to create lazy adaptive media for file version " + fileVersion.getFileVersionId()), (Throwable)pe);
        }
    }
}

