/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.demo.data.creator.internal;

import com.liferay.adaptive.media.demo.data.creator.AMImageConfigurationDemoDataCreator;
import com.liferay.adaptive.media.demo.data.creator.DemoAMImageConfigurationVariant;
import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationEntry;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AMImageConfigurationDemoDataCreator.class})
public class AMImageConfigurationDemoDataCreatorImpl
implements AMImageConfigurationDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(AMImageConfigurationDemoDataCreatorImpl.class);
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    private final Map<Long, List<String>> _configurationUuids = new HashMap<Long, List<String>>();

    public Collection<AMImageConfigurationEntry> create(long companyId) throws IOException {
        ArrayList<AMImageConfigurationEntry> amImageConfigurationEntries = new ArrayList<AMImageConfigurationEntry>();
        for (DemoAMImageConfigurationVariant demoAMImageConfigurationVariant : DemoAMImageConfigurationVariant.values()) {
            AMImageConfigurationEntry amImageConfigurationEntry = this.create(companyId, demoAMImageConfigurationVariant);
            amImageConfigurationEntries.add(amImageConfigurationEntry);
        }
        return amImageConfigurationEntries;
    }

    public AMImageConfigurationEntry create(long companyId, DemoAMImageConfigurationVariant demoAMImageConfigurationVariant) throws IOException {
        AMImageConfigurationEntry amImageConfigurationEntry = null;
        try {
            amImageConfigurationEntry = this._amImageConfigurationHelper.addAMImageConfigurationEntry(companyId, demoAMImageConfigurationVariant.getName(), demoAMImageConfigurationVariant.getDescription(), demoAMImageConfigurationVariant.getUuid(), demoAMImageConfigurationVariant.getProperties());
            this._addConfigurationUuid(companyId, amImageConfigurationEntry.getUUID());
        }
        catch (AMImageConfigurationException amImageConfigurationException) {
            _log.error((Object)"Unable to add image adaptive media configuration", (Throwable)amImageConfigurationException);
        }
        return amImageConfigurationEntry;
    }

    public void delete() throws IOException {
        for (Map.Entry<Long, List<String>> entry : this._configurationUuids.entrySet()) {
            Long companyId = entry.getKey();
            List<String> uuids = entry.getValue();
            for (String uuid : uuids) {
                this._amImageConfigurationHelper.forceDeleteAMImageConfigurationEntry(companyId.longValue(), uuid);
                uuids.remove(uuid);
            }
        }
    }

    private void _addConfigurationUuid(long companyId, String uuid) {
        this._configurationUuids.computeIfAbsent(companyId, k -> new CopyOnWriteArrayList());
        List<String> uuids = this._configurationUuids.get(companyId);
        uuids.add(uuid);
    }
}

