/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.content.transformer.internal;

import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerContentType;
import com.liferay.adaptive.media.content.transformer.ContentTransformerHandler;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ContentTransformerHandler.class})
public class ContentTransformerHandlerImpl
implements ContentTransformerHandler {
    private static final Log _log = LogFactoryUtil.getLog(ContentTransformerHandlerImpl.class);
    private ServiceTrackerMap<ContentTransformerContentType<?>, List<ContentTransformer<?>>> _serviceTrackerMap;

    public <T> T transform(ContentTransformerContentType<T> contentTransformerContentType, T originalContent) {
        List contentTransformers = (List)this._serviceTrackerMap.getService(contentTransformerContentType);
        if (contentTransformers == null) {
            return originalContent;
        }
        Object transformedContent = originalContent;
        for (ContentTransformer curContentTransformer : contentTransformers) {
            try {
                ContentTransformer contentTransformer = curContentTransformer;
                transformedContent = contentTransformer.transform(transformedContent);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
        return transformedContent;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ContentTransformer.class, null, (serviceReference, emitter) -> {
            ContentTransformer contentTransformer = (ContentTransformer)bundleContext.getService(serviceReference);
            emitter.emit((Object)contentTransformer.getContentTransformerContentType());
            bundleContext.ungetService(serviceReference);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected final void setServiceTrackerMap(ServiceTrackerMap<ContentTransformerContentType<?>, List<ContentTransformer<?>>> serviceTrackerMap) {
        this._serviceTrackerMap = serviceTrackerMap;
    }
}

