/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.content.transformer.internal;

import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;

public class HtmlContentTransformerImpl
implements ContentTransformer {
    private static final String _OPEN_TAG_TOKEN_IMG = "<img ";
    private final AMImageHTMLTagFactory _amImageHTMLTagFactory;
    private final AMImageMimeTypeProvider _amImageMimeTypeProvider;
    private final DLAppLocalService _dlAppLocalService;

    public HtmlContentTransformerImpl(AMImageHTMLTagFactory amImageHTMLTagFactory, AMImageMimeTypeProvider amImageMimeTypeProvider, DLAppLocalService dlAppLocalService) {
        this._amImageHTMLTagFactory = amImageHTMLTagFactory;
        this._amImageMimeTypeProvider = amImageMimeTypeProvider;
        this._dlAppLocalService = dlAppLocalService;
    }

    public String transform(String html) throws PortalException {
        if (html == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        int i = 0;
        while (i < html.length()) {
            int imgStart = html.indexOf(_OPEN_TAG_TOKEN_IMG, i);
            if (imgStart == -1) {
                sb.append(html.substring(i));
                break;
            }
            int imgEnd = html.indexOf(62, imgStart + _OPEN_TAG_TOKEN_IMG.length());
            if (imgEnd == -1) {
                sb.append(html.substring(i));
                break;
            }
            ++imgEnd;
            int attributeStart = html.indexOf("data-fileentryid", imgStart);
            if (attributeStart == -1) {
                sb.append(html.substring(i));
                break;
            }
            if (attributeStart > imgEnd) {
                sb.append(html.substring(i, imgEnd));
                i = imgEnd;
                continue;
            }
            int fileEntryIdStart = attributeStart + "data-fileentryid".length() + 2;
            int fileEntryIdEnd = html.indexOf(34, fileEntryIdStart);
            if (fileEntryIdEnd == -1 || fileEntryIdEnd > imgEnd) {
                sb.append(html.substring(i, imgEnd));
                i = imgEnd;
                continue;
            }
            long fileEntryId = GetterUtil.getLong((String)html.substring(fileEntryIdStart, fileEntryIdEnd));
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            if (!this._amImageMimeTypeProvider.isMimeTypeSupported(fileEntry.getMimeType())) {
                sb.append(html.substring(i, imgEnd));
                i = imgEnd;
                continue;
            }
            String replacement = this._amImageHTMLTagFactory.create(html.substring(imgStart, imgEnd), fileEntry);
            sb.append(html.substring(i, imgStart));
            sb.append(replacement);
            i = imgEnd;
        }
        return sb.toString();
    }
}

