/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.content.transformer.internal;

import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerHandler;
import com.liferay.adaptive.media.content.transformer.internal.HtmlContentTransformerImpl;
import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.mime.type.AMImageMimeTypeProvider;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentTransformerHandler.class})
public class ContentTransformerHandlerImpl
implements ContentTransformerHandler {
    private static final Log _log = LogFactoryUtil.getLog(ContentTransformerHandlerImpl.class);
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private AMImageMimeTypeProvider _amImageMimeTypeProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private ContentTransformer _htmlContentTransformer;
    private ServiceTrackerList<ContentTransformer> _serviceTrackerList;

    public String transform(String originalContent) {
        String transformedContent;
        block5: {
            transformedContent = originalContent;
            try {
                transformedContent = this._htmlContentTransformer.transform(originalContent);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        for (ContentTransformer contentTransformer : this._serviceTrackerList) {
            try {
                transformedContent = contentTransformer.transform(transformedContent);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
        return transformedContent;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ContentTransformer.class);
        this._htmlContentTransformer = new HtmlContentTransformerImpl(this._amImageHTMLTagFactory, this._amImageMimeTypeProvider, this._dlAppLocalService);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected final void setServiceTrackerList(ServiceTrackerList<ContentTransformer> serviceTrackerList) {
        this._serviceTrackerList = serviceTrackerList;
    }
}

