/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.content.transformer;

import com.liferay.adaptive.media.content.transformer.ContentTransformer;
import com.liferay.adaptive.media.content.transformer.ContentTransformerContentType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseRegexStringContentTransformer
implements ContentTransformer<String> {
    @Override
    public abstract ContentTransformerContentType<String> getContentTransformerContentType();

    @Override
    public String transform(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            return content;
        }
        Pattern pattern = this.getPattern();
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = null;
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer(content.length());
            }
            String replacement = this.getReplacement(matcher.group(0), this.getFileEntry(matcher));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        if (sb != null) {
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    protected abstract FileEntry getFileEntry(Matcher var1) throws PortalException;

    protected abstract Pattern getPattern();

    protected abstract String getReplacement(String var1, FileEntry var2) throws PortalException;
}

