/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media;

import aQute.bnd.annotation.ProviderType;
import com.liferay.adaptive.media.AMDistanceComparator;
import com.liferay.adaptive.media.util.AMAttributeConverterUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@ProviderType
public final class AMAttribute<T, V> {
    private static final AMAttribute<?, String> _AM_ATTRIBUTE_CONFIGURATION_UUID = new AMAttribute("configuration-uuid", s -> s, String::compareTo);
    private static final AMAttribute<?, Long> _AM_ATTRIBUTE_CONTENT_LENGTH = new AMAttribute("content-length", AMAttributeConverterUtil::parseLong, (value1, value2) -> value1 - value2);
    private static final AMAttribute<?, String> _AM_ATTRIBUTE_CONTENT_TYPE = new AMAttribute("content-type", value -> value, String::compareTo);
    private static final AMAttribute<?, String> _AM_ATTRIBUTE_FILE_NAME = new AMAttribute("file-name", value -> value, String::compareTo);
    private static final Map<String, AMAttribute<?, ?>> _allowedAMAttributes = new HashMap<String, AMAttribute<?, ?>>(){
        {
            this.put(_AM_ATTRIBUTE_CONFIGURATION_UUID.getName(), _AM_ATTRIBUTE_CONFIGURATION_UUID);
            this.put(_AM_ATTRIBUTE_CONTENT_LENGTH.getName(), _AM_ATTRIBUTE_CONTENT_LENGTH);
            this.put(_AM_ATTRIBUTE_CONTENT_TYPE.getName(), _AM_ATTRIBUTE_CONTENT_TYPE);
            this.put(_AM_ATTRIBUTE_FILE_NAME.getName(), _AM_ATTRIBUTE_FILE_NAME);
        }
    };
    private final AMDistanceComparator<V> _amDistanceComparator;
    private final Function<String, V> _converterFunction;
    private final String _name;

    public static Map<String, AMAttribute<?, ?>> getAllowedAMAttributes() {
        return _allowedAMAttributes;
    }

    public static final <S> AMAttribute<S, String> getConfigurationUuidAMAttribute() {
        return _AM_ATTRIBUTE_CONFIGURATION_UUID;
    }

    public static final <S> AMAttribute<S, Long> getContentLengthAMAttribute() {
        return _AM_ATTRIBUTE_CONTENT_LENGTH;
    }

    public static final <S> AMAttribute<S, String> getContentTypeAMAttribute() {
        return _AM_ATTRIBUTE_CONTENT_TYPE;
    }

    public static final <S> AMAttribute<S, String> getFileNameAMAttribute() {
        return _AM_ATTRIBUTE_FILE_NAME;
    }

    public AMAttribute(String name, Function<String, V> converter, AMDistanceComparator<V> amDistanceComparator) {
        this._name = name;
        this._converterFunction = converter;
        this._amDistanceComparator = amDistanceComparator;
    }

    public long compare(V value1, V value2) {
        return this._amDistanceComparator.compare(value1, value2);
    }

    public V convert(String value) {
        return this._converterFunction.apply(value);
    }

    public long distance(V value1, V value2) {
        return Math.abs(this._amDistanceComparator.compare(value1, value2));
    }

    public String getName() {
        return this._name;
    }
}

