/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class IntegerFromCharSequenceNotationConverter
implements NotationConverter<CharSequence, Integer> {
    @Override
    public void convert(CharSequence notation, NotationConvertResult<? super Integer> result) throws TypeConversionException {
        try {
            result.converted(Integer.valueOf(notation.toString()));
        }
        catch (NumberFormatException ex) {
            throw new TypeConversionException(String.format("Cannot convert string value '%s' to an integer.", notation), ex);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("An integer.");
    }
}

