/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Pair;
import org.gradle.internal.classloader.TransformReplacer;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathFileHasher;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.types.GradleCoreInstrumentingTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.JarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentingClasspathFileTransformer.class);
    private static final int CACHE_FORMAT = 6;
    private static final int AGENT_INSTRUMENTATION_VERSION = 3;
    private final FileLockManager fileLockManager;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final ClasspathFileHasher fileHasher;
    private final Policy policy;
    private final CachedClasspathTransformer.Transform transform;

    public InstrumentingClasspathFileTransformer(FileLockManager fileLockManager, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, ClasspathFileHasher classpathFileHasher, Policy policy, CachedClasspathTransformer.Transform transform, GradleCoreInstrumentingTypeRegistry gradleCoreInstrumentingTypeRegistry) {
        this.fileLockManager = fileLockManager;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.fileHasher = InstrumentingClasspathFileTransformer.createFileHasherWithConfig(InstrumentingClasspathFileTransformer.configHashFor(policy, transform, gradleCoreInstrumentingTypeRegistry), classpathFileHasher);
        this.policy = policy;
        this.transform = transform;
    }

    private static HashCode configHashFor(Policy policy, CachedClasspathTransformer.Transform transform, GradleCoreInstrumentingTypeRegistry gradleCoreInstrumentingTypeRegistry) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putInt(6);
        hasher.putInt(21);
        gradleCoreInstrumentingTypeRegistry.getInstrumentedFileHash().ifPresent(arg_0 -> ((Hasher)hasher).putHash(arg_0));
        policy.applyConfigurationTo(hasher);
        transform.applyConfigurationTo(hasher);
        return hasher.hash();
    }

    private static ClasspathFileHasher createFileHasherWithConfig(HashCode configHash, ClasspathFileHasher fileHasher) {
        return sourceSnapshot -> {
            Hasher hasher = Hashing.defaultFunction().newHasher();
            hasher.putHash(configHash);
            hasher.putHash(fileHasher.hashOf(sourceSnapshot));
            return hasher.hash();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir, InstrumentingTypeRegistry typeRegistry) {
        String destDirName = this.hashOf(sourceSnapshot);
        File destDir = new File(cacheDir, destDirName);
        String destFileName = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        File receipt = new File(destDir, destFileName + ".receipt");
        File transformed = new File(destDir, destFileName);
        if (receipt.isFile()) {
            return transformed;
        }
        File lockFile = new File(destDir, destFileName + ".lock");
        try (FileLock fileLock = this.exclusiveLockFor(lockFile);){
            if (receipt.isFile()) {
                File file = transformed;
                return file;
            }
            this.transform(source, transformed, typeRegistry);
            try {
                receipt.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create receipt for instrumented classpath file '%s/%s'.", destDirName, destFileName), e);
            }
            File file = transformed;
            return file;
        }
    }

    @Override
    public ClasspathFileHasher getFileHasher() {
        return this.fileHasher;
    }

    private FileLock exclusiveLockFor(File file) {
        return this.fileLockManager.lock(file, (LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation(), "instrumented jar cache");
    }

    private String hashOf(FileSystemLocationSnapshot sourceSnapshot) {
        return this.fileHasher.hashOf(sourceSnapshot).toString();
    }

    private void transform(File source, File dest, InstrumentingTypeRegistry typeRegistry) {
        this.policy.createTransformer(this, source, typeRegistry).transform(dest);
    }

    public static Policy instrumentForLoadingWithClassLoader() {
        return new Policy(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Transformation createTransformer(InstrumentingClasspathFileTransformer owner, File source, InstrumentingTypeRegistry typeRegistry) {
                Boolean isMultiReleaseJar = null;
                if (source.isFile()) {
                    try (ZipInput entries2 = FileZipInput.create((File)source);){
                        for (ZipEntry entry : entries2) {
                            String entryName = entry.getName();
                            if (this.isJarSignatureFile(entryName)) {
                                SkipTransformation skipTransformation = new SkipTransformation(source);
                                return skipTransformation;
                            }
                            if (isMultiReleaseJar != null || !JarUtil.isManifestName((String)entryName)) continue;
                            isMultiReleaseJar = JarUtil.isMultiReleaseJarManifest((Manifest)JarUtil.readManifest((byte[])entry.getContent()));
                        }
                    }
                    catch (FileException entries2) {
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (isMultiReleaseJar != null && isMultiReleaseJar.booleanValue()) {
                    InstrumentingClasspathFileTransformer instrumentingClasspathFileTransformer = owner;
                    Objects.requireNonNull(instrumentingClasspathFileTransformer);
                    return instrumentingClasspathFileTransformer.new MultiReleaseTransformationForLegacy(source, typeRegistry);
                }
                InstrumentingClasspathFileTransformer instrumentingClasspathFileTransformer = owner;
                Objects.requireNonNull(instrumentingClasspathFileTransformer);
                return instrumentingClasspathFileTransformer.new BaseTransformation(source, typeRegistry);
            }

            private boolean isJarSignatureFile(String entryName) {
                return entryName.startsWith("META-INF/") && entryName.endsWith(".SF");
            }

            public String toString() {
                return "Policy(legacy)";
            }
        };
    }

    public static Policy instrumentForLoadingWithAgent() {
        return new Policy(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
                hasher.putInt(3);
            }

            @Override
            public Transformation createTransformer(InstrumentingClasspathFileTransformer owner, File file, InstrumentingTypeRegistry typeRegistry) {
                InstrumentingClasspathFileTransformer instrumentingClasspathFileTransformer = owner;
                Objects.requireNonNull(instrumentingClasspathFileTransformer);
                return instrumentingClasspathFileTransformer.new TransformationForAgent(file, typeRegistry);
            }

            public String toString() {
                return "Policy(agent)";
            }
        };
    }

    private static boolean isSupportedVersion(int javaMajorVersion) {
        return javaMajorVersion <= 21;
    }

    @NonNullApi
    public static class MrJarUtils {
        public static boolean isInUnsupportedMrJarVersionedDirectory(ClasspathEntryVisitor.Entry entry) {
            OptionalInt version = JarUtil.getVersionedDirectoryMajorVersion((String)entry.getName());
            if (version.isPresent()) {
                return !InstrumentingClasspathFileTransformer.isSupportedVersion(version.getAsInt());
            }
            return false;
        }
    }

    private class TransformationForAgent
    extends BaseTransformation {
        private int lowestUnsupportedVersionInJar;
        private boolean isMultiReleaseJar;

        public TransformationForAgent(File source, InstrumentingTypeRegistry typeRegistry) {
            super(source, typeRegistry);
            this.lowestUnsupportedVersionInJar = Integer.MAX_VALUE;
        }

        @Override
        protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
            int version = JarUtil.getVersionedDirectoryMajorVersion((String)classEntry.getName()).orElse(1);
            if (InstrumentingClasspathFileTransformer.isSupportedVersion(version)) {
                super.processClassFile(builder, classEntry);
            } else if (this.lowestUnsupportedVersionInJar > version) {
                this.lowestUnsupportedVersionInJar = version;
            }
        }

        @Override
        protected void processManifest(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry manifestEntry) throws IOException {
            try {
                Manifest parsedManifest = JarUtil.readManifest((byte[])manifestEntry.getContent());
                if (!JarUtil.isMultiReleaseJarManifest((Manifest)parsedManifest)) {
                    return;
                }
                this.isMultiReleaseJar = true;
                Manifest processedManifest = new Manifest();
                this.copyManifestMainAttribute(parsedManifest, processedManifest, Attributes.Name.MANIFEST_VERSION);
                this.setManifestMainAttribute(processedManifest, "Multi-Release", "true");
                builder.put(manifestEntry.getName(), this.toByteArray(processedManifest), manifestEntry.getCompressionMethod());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse Manifest from JAR " + this.source);
                throw e;
            }
        }

        @Override
        protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) {
        }

        @Override
        protected void finishProcessing(ClasspathBuilder.EntryBuilder builder) throws IOException {
            if (this.isMultiReleaseJar) {
                builder.put(TransformReplacer.MarkerResource.RESOURCE_NAME, TransformReplacer.MarkerResource.TRANSFORMED.asBytes());
                if (this.hasUnsupportedVersionInJar()) {
                    builder.put(JarUtil.toVersionedPath((int)this.lowestUnsupportedVersionInJar, (String)TransformReplacer.MarkerResource.RESOURCE_NAME), TransformReplacer.MarkerResource.NOT_TRANSFORMED.asBytes());
                }
            }
        }

        private boolean hasUnsupportedVersionInJar() {
            return this.lowestUnsupportedVersionInJar < Integer.MAX_VALUE;
        }

        private void copyManifestMainAttribute(Manifest source, Manifest destination, Attributes.Name name) {
            destination.getMainAttributes().put(name, source.getMainAttributes().getValue(name));
        }

        private void setManifestMainAttribute(Manifest manifest, String name, String value) {
            manifest.getMainAttributes().putValue(name, value);
        }

        private byte[] toByteArray(Manifest manifest) throws IOException {
            ByteArrayOutputStream manifestOutput = new ByteArrayOutputStream(512);
            manifest.write(manifestOutput);
            return manifestOutput.toByteArray();
        }
    }

    private class MultiReleaseTransformationForLegacy
    extends BaseTransformation {
        public MultiReleaseTransformationForLegacy(File source, InstrumentingTypeRegistry typeRegistry) {
            super(source, typeRegistry);
        }

        @Override
        protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
            if (!MrJarUtils.isInUnsupportedMrJarVersionedDirectory(classEntry)) {
                super.processClassFile(builder, classEntry);
            }
        }

        @Override
        protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) throws IOException {
            if (!MrJarUtils.isInUnsupportedMrJarVersionedDirectory(resourceEntry)) {
                super.processResource(builder, resourceEntry);
            }
        }
    }

    private class BaseTransformation
    implements Transformation {
        protected final File source;
        private final InstrumentingTypeRegistry typeRegistry;

        public BaseTransformation(File source, InstrumentingTypeRegistry typeRegistry) {
            this.source = source;
            this.typeRegistry = typeRegistry;
        }

        @Override
        public final void transform(File destination) {
            InstrumentingClasspathFileTransformer.this.classpathBuilder.jar(destination, builder -> {
                try {
                    this.visitEntries(builder);
                }
                catch (FileException e) {
                    LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)this.source.getName(), (Object)e);
                }
            });
        }

        private void visitEntries(ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
            InstrumentingClasspathFileTransformer.this.classpathWalker.visit(this.source, entry -> this.visitEntry(builder, entry));
            this.finishProcessing(builder);
        }

        private void visitEntry(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry) throws IOException {
            try {
                if (this.isClassFile(entry)) {
                    this.processClassFile(builder, entry);
                } else if (this.isManifest(entry)) {
                    this.processManifest(builder, entry);
                } else {
                    this.processResource(builder, entry);
                }
            }
            catch (Throwable e) {
                throw new IOException("Failed to process the entry '" + entry.getName() + "' from '" + this.source + "'", e);
            }
        }

        protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
            ClassReader reader = new ClassReader(classEntry.getContent());
            ClassWriter classWriter = new ClassWriter(1);
            Pair<RelativePath, ClassVisitor> chain = InstrumentingClasspathFileTransformer.this.transform.apply(classEntry, (ClassVisitor)classWriter, new ClassData(reader, this.typeRegistry));
            reader.accept((ClassVisitor)chain.right, 0);
            byte[] bytes = classWriter.toByteArray();
            builder.put(((RelativePath)chain.left).getPathString(), bytes, classEntry.getCompressionMethod());
        }

        protected void processManifest(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry manifestEntry) throws IOException {
            this.processResource(builder, manifestEntry);
        }

        protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) throws IOException {
            builder.put(resourceEntry.getName(), resourceEntry.getContent(), resourceEntry.getCompressionMethod());
        }

        protected void finishProcessing(ClasspathBuilder.EntryBuilder builder) throws IOException {
        }

        private boolean isClassFile(ClasspathEntryVisitor.Entry entry) {
            return entry.getName().endsWith(".class");
        }

        private boolean isManifest(ClasspathEntryVisitor.Entry entry) {
            return JarUtil.isManifestName((String)entry.getName());
        }
    }

    private static class SkipTransformation
    implements Transformation {
        private final File source;

        public SkipTransformation(File source) {
            this.source = source;
        }

        @Override
        public void transform(File destination) {
            LOGGER.debug("Archive '{}' rejected by policy. Skipping instrumentation.", (Object)this.source.getName());
            GFileUtils.copyFile((File)this.source, (File)destination);
        }
    }

    private static interface Transformation {
        public void transform(File var1);
    }

    public static interface Policy {
        public void applyConfigurationTo(Hasher var1);

        public Transformation createTransformer(InstrumentingClasspathFileTransformer var1, File var2, InstrumentingTypeRegistry var3);
    }
}

