/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.io.input.CloseShieldInputStream;

public class Prompter {
    public static boolean confirm(String question, InputStream in, PrintStream out, Optional<Boolean> defaultAnswer) {
        String questionWithPrompt = Prompter._buildBooleanQuestionWithPrompt(question, defaultAnswer);
        Optional<Boolean> answer = Prompter._getBooleanAnswer(questionWithPrompt, in, out, defaultAnswer);
        if (answer.isPresent()) {
            return answer.get();
        }
        throw new NoSuchElementException("Unable to acquire an answer");
    }

    public static String promptString(String question, BufferedReader reader, PrintStream outputStream) {
        Optional<String> answer = Prompter._getStringAnswer(question, reader, outputStream, Optional.empty());
        if (answer.isPresent()) {
            return answer.get();
        }
        throw new NoSuchElementException("Unable to acquire an answer");
    }

    private static String _buildBooleanQuestionWithPrompt(String question, Optional<Boolean> defaultAnswer) {
        String yesDefault = "y";
        String noDefault = "n";
        if (defaultAnswer.isPresent()) {
            if (defaultAnswer.get().booleanValue()) {
                yesDefault = "Y";
            } else {
                noDefault = "N";
            }
        }
        return question + " (" + yesDefault + "/" + noDefault + ")";
    }

    private static Optional<Boolean> _getBooleanAnswer(String questionWithPrompt, InputStream inputStream, PrintStream printStream, Optional<Boolean> defaultAnswer) {
        Optional<Boolean> answer;
        block41: {
            answer = null;
            try (CloseShieldInputStream closeShieldInputStream = new CloseShieldInputStream(inputStream);
                 Scanner scanner = new Scanner(closeShieldInputStream);){
                while (answer == null || !answer.isPresent()) {
                    printStream.println(questionWithPrompt);
                    String line = null;
                    block32: while (!(answer != null && answer.isPresent() || Objects.equals(answer, defaultAnswer) || !scanner.hasNextLine())) {
                        line = scanner.nextLine();
                        if (line != null) {
                            line = line.toLowerCase();
                            switch (line.trim()) {
                                case "y": 
                                case "yes": {
                                    answer = Optional.of(true);
                                    continue block32;
                                }
                                case "n": 
                                case "no": {
                                    answer = Optional.of(false);
                                    continue block32;
                                }
                            }
                            if (defaultAnswer.isPresent()) {
                                answer = defaultAnswer;
                                continue;
                            }
                            printStream.println("Unrecognized input: " + line);
                            continue;
                        }
                        answer = defaultAnswer;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(illegalStateException);
            }
            catch (Exception exception) {
                if (!defaultAnswer.isPresent()) break block41;
                answer = defaultAnswer;
            }
        }
        return answer;
    }

    private static Optional<String> _getStringAnswer(String questionWithPrompt, BufferedReader reader, PrintStream printStream, Optional<String> defaultAnswer) {
        Optional<String> answer;
        block9: {
            answer = Optional.empty();
            try {
                block3: while (answer == null || !answer.isPresent()) {
                    if (questionWithPrompt != null && questionWithPrompt.length() > 0) {
                        printStream.println(questionWithPrompt);
                    }
                    printStream.print("> ");
                    answer = Optional.of(reader.readLine());
                    while (!(answer != null && answer.isPresent() || Objects.equals(answer, defaultAnswer))) {
                        String line = reader.readLine();
                        if (line != null) {
                            if ((line = line.trim()).length() > 0) {
                                answer = Optional.of(line);
                                continue block3;
                            }
                            if (defaultAnswer.isPresent()) {
                                answer = defaultAnswer;
                                continue;
                            }
                            printStream.println("Unrecognized input: " + line);
                            continue;
                        }
                        answer = defaultAnswer;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException(illegalStateException);
            }
            catch (Exception exception) {
                if (!defaultAnswer.isPresent()) break block9;
                answer = defaultAnswer;
            }
        }
        return answer;
    }
}

