/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.jmx;

import com.liferay.blade.cli.jmx.JMXLocalConnector;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.osgi.framework.dto.BundleDTO;

public class JMXBundleDeployer
extends JMXLocalConnector {
    private static final String _NAME = "osgi.core";
    private static final String _TYPE = "framework";

    public JMXBundleDeployer(Consumer<String> logger) throws MalformedURLException {
        super("osgi.core:type=framework,*", logger);
    }

    public JMXBundleDeployer(int port) throws MalformedURLException {
        super(port);
    }

    public long deploy(String bsn, String bundleUrl) throws Exception {
        Object[] params;
        ObjectName framework = this._getFramework(this.mBeanServerConnection);
        long bundleId = -1L;
        for (BundleDTO osgiBundle : this.listBundles()) {
            if (!osgiBundle.symbolicName.equals(bsn)) continue;
            bundleId = osgiBundle.id;
            break;
        }
        if (bundleId > -1L) {
            this.mBeanServerConnection.invoke(framework, "stopBundle", new Object[]{bundleId}, new String[]{"long"});
            params = new Object[]{bundleId, bundleUrl};
            this.mBeanServerConnection.invoke(framework, "updateBundleFromURL", params, new String[]{"long", String.class.getName()});
            this.mBeanServerConnection.invoke(framework, "refreshBundle", new Object[]{bundleId}, new String[]{"long"});
        } else {
            params = new Object[]{bundleUrl, bundleUrl};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            Object installed = this.mBeanServerConnection.invoke(framework, "installBundleFromURL", params, signature);
            bundleId = Long.parseLong(installed.toString());
        }
        this.mBeanServerConnection.invoke(framework, "startBundle", new Object[]{bundleId}, new String[]{"long"});
        return bundleId;
    }

    public BundleDTO[] listBundles() {
        ArrayList<BundleDTO> retval = new ArrayList<BundleDTO>();
        try {
            ObjectName bundleState = this._getBundleState();
            Object[] params = new Object[]{new String[]{"Identifier", "SymbolicName", "State", "Version"}};
            String[] signature = new String[]{String[].class.getName()};
            TabularData data = (TabularData)this.mBeanServerConnection.invoke(bundleState, "listBundles", params, signature);
            for (Object value : data.values()) {
                CompositeData cd = (CompositeData)value;
                try {
                    retval.add(this._newFromData(cd));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval.toArray(new BundleDTO[0]);
    }

    public void uninstall(long id) throws Exception {
        ObjectName framework = this._getFramework(this.mBeanServerConnection);
        Object[] objects = new Object[]{id};
        String[] params = new String[]{"long"};
        this.mBeanServerConnection.invoke(framework, "uninstallBundle", objects, params);
    }

    public void uninstall(String bsn) throws Exception {
        for (BundleDTO osgiBundle : this.listBundles()) {
            if (!osgiBundle.symbolicName.equals(bsn)) continue;
            this.uninstall(osgiBundle.id);
            return;
        }
        throw new IllegalStateException("Unable to uninstall " + bsn);
    }

    private ObjectName _getBundleState() throws IOException, MalformedObjectNameException {
        ObjectName objectName = new ObjectName("osgi.core:type=bundleState,*");
        Set<ObjectName> queryNames = this.mBeanServerConnection.queryNames(objectName, null);
        Iterator<ObjectName> iterator = queryNames.iterator();
        return iterator.next();
    }

    private ObjectName _getFramework(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectName("osgi.core:type=framework,*");
        Set<ObjectName> objectNames = mBeanServerConnection.queryNames(objectName, null);
        if (objectNames != null && !objectNames.isEmpty()) {
            Iterator<ObjectName> iterator = objectNames.iterator();
            return iterator.next();
        }
        return null;
    }

    private BundleDTO _newFromData(CompositeData cd) {
        BundleDTO dto = new BundleDTO();
        Object identifier = cd.get("Identifier");
        dto.id = Long.parseLong(identifier.toString());
        Object symbolicName = cd.get("SymbolicName");
        dto.symbolicName = symbolicName.toString();
        Object state = cd.get("State");
        if (Objects.equals(state, "UNINSTALLED")) {
            dto.state = 1;
        } else if (Objects.equals(state, "INSTALLED")) {
            dto.state = 2;
        } else if (Objects.equals(state, "RESOLVED")) {
            dto.state = 4;
        } else if (Objects.equals(state, "STARTING")) {
            dto.state = 8;
        } else if (Objects.equals(state, "STOPPING")) {
            dto.state = 16;
        } else if (Objects.equals(state, "ACTIVE")) {
            dto.state = 32;
        }
        Object version = cd.get("Version");
        dto.version = version.toString();
        return dto;
    }
}

