/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.OpenArgs;
import com.liferay.blade.cli.jmx.IDEConnector;
import java.io.File;
import java.util.Collections;

public class OpenCommand
extends BaseCommand<OpenArgs> {
    @Override
    public void execute() throws Exception {
        OpenArgs openArgs = (OpenArgs)this.getArgs();
        File file = openArgs.getFile();
        if (file == null) {
            file = openArgs.getBase();
        }
        if (!(file = file.getAbsoluteFile()).exists()) {
            this._addError("open", "Unable to find specified file " + file.getAbsolutePath());
            return;
        }
        BladeCLI bladeCLI = this.getBladeCLI();
        bladeCLI.trace("Trying to open directory : " + file, new Object[0]);
        try {
            IDEConnector connector;
            Object retval;
            if (file.isDirectory() && (retval = (connector = new IDEConnector(trace -> bladeCLI.trace((String)trace, new Object[0]))).openDir(file)) != null) {
                this._addError("open", retval.toString());
            }
        }
        catch (Exception exception) {
            bladeCLI.error("Unable to connect to IDE to open directory.");
            exception.printStackTrace(bladeCLI.error());
        }
    }

    @Override
    public Class<OpenArgs> getArgsClass() {
        return OpenArgs.class;
    }

    private void _addError(String prefix, String msg) {
        BladeCLI bladeCLI = this.getBladeCLI();
        bladeCLI.addErrors(prefix, Collections.singleton(msg));
    }
}

