/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.gradle.GradleWorkspaceProvider;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class LocalServer {
    private Optional<Path> _appServerPath;
    private Path _liferayHomePath;
    private String _serverType;

    public LocalServer(BladeCLI bladeCLI) {
        if (bladeCLI.isWorkspace()) {
            Path tempLiferayHome;
            String bundleUrl;
            String bundleArtifactName;
            Properties properties = this.getWorkspaceProperties(bladeCLI);
            String liferayHomePath = properties.getProperty("liferay.workspace.home.dir");
            if (liferayHomePath == null || liferayHomePath.equals("")) {
                liferayHomePath = "bundles";
            }
            if ((bundleArtifactName = properties.getProperty("liferay.workspace.bundle.artifact.name")) != null) {
                if (bundleArtifactName.contains("jboss")) {
                    this._serverType = "jboss";
                } else if (bundleArtifactName.contains("tomcat")) {
                    this._serverType = "tomcat";
                } else if (bundleArtifactName.contains("wildfly")) {
                    this._serverType = "wildfly";
                }
            }
            if (this._serverType == null && (bundleUrl = properties.getProperty("liferay.workspace.bundle.url")) != null) {
                if (bundleUrl.contains("tomcat")) {
                    this._serverType = "tomcat";
                } else if (bundleUrl.contains("jboss")) {
                    this._serverType = "jboss";
                } else if (bundleUrl.contains("wildfly")) {
                    this._serverType = "wildfly";
                }
            }
            if (this._serverType == null) {
                this._serverType = "tomcat";
            }
            if ((tempLiferayHome = Paths.get(liferayHomePath, new String[0])).isAbsolute()) {
                this._liferayHomePath = tempLiferayHome.normalize();
            } else {
                File workspaceRootDir = this.getWorkspaceDir(bladeCLI);
                Path workspaceRootDirPath = workspaceRootDir.toPath();
                Path tempFile = workspaceRootDirPath.resolve(liferayHomePath);
                this._liferayHomePath = tempFile.normalize();
            }
        } else {
            BaseArgs baseArgs = bladeCLI.getArgs();
            File baseDir = baseArgs.getBase();
            List<Properties> propertiesList = BladeUtil.getAppServerProperties(baseDir);
            String appServerParentDir = "";
            for (Properties properties : propertiesList) {
                String serverTypeTemp;
                String appServerParentDirTemp;
                if (appServerParentDir.equals("") && (appServerParentDirTemp = properties.getProperty("app.server.parent.dir")) != null && !appServerParentDirTemp.equals("")) {
                    Path rootDirRealPath = baseDir.toPath();
                    try {
                        rootDirRealPath = rootDirRealPath.toRealPath(new LinkOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    appServerParentDir = appServerParentDirTemp = appServerParentDirTemp.replace("${project.dir}", rootDirRealPath.toString());
                }
                if (this._serverType != null && !this._serverType.equals("") || (serverTypeTemp = properties.getProperty("app.server.type")) == null || serverTypeTemp.equals("")) continue;
                this._serverType = serverTypeTemp;
            }
            if (appServerParentDir.startsWith("/") || appServerParentDir.contains(":")) {
                this._liferayHomePath = Paths.get(appServerParentDir, new String[0]);
            } else {
                Path rootDirRealPath = baseDir.toPath();
                try {
                    rootDirRealPath = rootDirRealPath.toRealPath(new LinkOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._liferayHomePath = rootDirRealPath.resolve(appServerParentDir);
            }
        }
        try {
            this._appServerPath = ServerUtil.findAppServerPath(this._liferayHomePath, this._serverType);
        }
        catch (IOException ioException) {
            this._appServerPath = Optional.empty();
        }
    }

    public Optional<Path> getAppServerPath() throws IOException {
        return this._appServerPath;
    }

    public Path getLiferayHomePath() {
        return this._liferayHomePath;
    }

    public Optional<Path> getLogPath() {
        if (this._serverType.equals("tomcat")) {
            return this._appServerPath.map(path -> path.resolve("logs/catalina.out"));
        }
        if (this._serverType.equals("jboss") || this._serverType.equals("wildfly")) {
            return this._appServerPath.map(path -> path.resolve("standalone/log/server.log"));
        }
        return Optional.empty();
    }

    public String getServerType() {
        return this._serverType;
    }

    public boolean isSupported() throws IOException {
        Optional<Path> serverBinPath = this.getAppServerPath();
        String serverType = this.getServerType();
        return serverBinPath.isPresent() && (serverType.equals("tomcat") || serverType.equals("jboss") || serverType.equals("wildfly"));
    }

    public ProcessBuilder newLocalServerProcess() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this._serverType.equals("tomcat")) {
            this._buildTomcatProcess(processBuilder);
        } else if (this._serverType.equals("jboss") || this._serverType.equalsIgnoreCase("wildfly")) {
            this._buildJbossWildflyProcess(processBuilder);
        }
        return processBuilder;
    }

    protected File getWorkspaceDir(BladeCLI bladeCLI) {
        BaseArgs baseArgs = bladeCLI.getArgs();
        File baseDir = baseArgs.getBase();
        WorkspaceProvider workspaceProvider = bladeCLI.getWorkspaceProvider(baseDir);
        return workspaceProvider.getWorkspaceDir(baseDir);
    }

    protected Properties getWorkspaceProperties(BladeCLI bladeCLI) {
        BaseArgs baseArgs = bladeCLI.getArgs();
        File baseDir = baseArgs.getBase();
        GradleWorkspaceProvider workspaceProviderGradle = (GradleWorkspaceProvider)bladeCLI.getWorkspaceProvider(baseDir);
        return workspaceProviderGradle.getGradleProperties(baseDir);
    }

    private void _buildJbossWildflyProcess(ProcessBuilder processBuilder) {
        if (BladeUtil.isWindows()) {
            processBuilder.command("cmd.exe", "/C", this._getJBossWildflyExecutable());
        } else {
            processBuilder.command(this._getJBossWildflyExecutable());
        }
        Path appServer = this._appServerPath.get();
        Path binPath = appServer.resolve("bin");
        processBuilder.directory(binPath.toFile());
    }

    private void _buildTomcatProcess(ProcessBuilder processBuilder) throws IOException {
        Path catalinaOutPath;
        Optional<Path> appServerPath = this.getAppServerPath();
        Path appServer = appServerPath.get();
        Path logsPath = appServer.resolve("logs");
        if (!Files.exists(logsPath, new LinkOption[0])) {
            Files.createDirectory(logsPath, new FileAttribute[0]);
        }
        if (!Files.exists(catalinaOutPath = logsPath.resolve("catalina.out"), new LinkOption[0])) {
            Files.createFile(catalinaOutPath, new FileAttribute[0]);
        }
        Path binPath = appServer.resolve("bin");
        processBuilder.directory(binPath.toFile());
        Map<String, String> environment = processBuilder.environment();
        environment.put("CATALINA_PID", "catalina.pid");
        if (BladeUtil.isWindows()) {
            processBuilder.command("cmd.exe", "/C", this._getTomcatExecutable());
        } else {
            processBuilder.command(this._getTomcatExecutable());
        }
    }

    private String _getJBossWildflyExecutable() {
        String executable = "./standalone.sh";
        if (BladeUtil.isWindows()) {
            executable = "standalone.bat";
        }
        return executable;
    }

    private String _getTomcatExecutable() {
        String executable = "./catalina.sh";
        if (BladeUtil.isWindows()) {
            executable = "catalina.bat";
        }
        return executable;
    }
}

