/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.InstallExtensionArgs;
import com.liferay.blade.cli.gradle.GradleExec;
import com.liferay.blade.cli.gradle.GradleTooling;
import com.liferay.blade.cli.gradle.ProcessResult;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.FileUtil;
import com.liferay.blade.cli.util.Prompter;
import com.liferay.blade.cli.util.StringUtil;
import com.liferay.blade.gradle.tooling.ProjectInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InstallExtensionCommand
extends BaseCommand<InstallExtensionArgs> {
    private static final FileSystem _fileSystem = FileSystems.getDefault();
    private static final PathMatcher _templatePathMatcher = _fileSystem.getPathMatcher("glob:**/*.project.templates.*");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws Exception {
        Set<Path> paths;
        Path gradleBuildPath;
        String pathArgLower;
        InstallExtensionArgs args = (InstallExtensionArgs)this.getArgs();
        String pathArg = args.getPath();
        if (StringUtil.isNullOrEmpty(pathArg)) {
            pathArg = ".";
        }
        if ((pathArgLower = pathArg.toLowerCase()).startsWith("http") && this._isValidURL(pathArg)) {
            if (!pathArgLower.contains("//github.com/")) throw new Exception("Only github http(s) links are supported");
            String[] urlSplit = pathArgLower.split("github.com");
            String[] urlSplitEnd = urlSplit[1].split("/");
            List<String> segments = Arrays.asList(urlSplitEnd);
            Stream urlSplitEndStream = segments.stream();
            segments = urlSplitEndStream.filter(x -> x.length() > 0).collect(Collectors.toList());
            BladeCLI bladeCLI = this.getBladeCLI();
            if (segments.size() > 2) {
                Path extractedDirectory;
                StringBuilder githubRootUrl = new StringBuilder("https://github.com/");
                StringBuilder subpath = new StringBuilder();
                int x2 = 0;
                for (String segment : segments) {
                    if (x2 > 3) {
                        subpath.append(segment + '/');
                    } else if (x2 < 2) {
                        githubRootUrl.append(segment + '/');
                    }
                    ++x2;
                }
                Path projectPath = Files.createTempDirectory("extension", new FileAttribute[0]);
                boolean quiet = args.isQuiet();
                if (!quiet) {
                    bladeCLI.out("Downloading github repository " + githubRootUrl);
                }
                Path masterZipPath = BladeUtil.downloadGithubProject(String.valueOf(githubRootUrl), "master.zip");
                if (!quiet) {
                    bladeCLI.out("Unzipping github repository to " + projectPath);
                }
                FileUtil.unzip(masterZipPath.toFile(), projectPath.toFile(), null);
                try (Stream<Path> fileStream = Files.list(projectPath);){
                    extractedDirectory = fileStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElse(null);
                }
                Path projectSubpath = Paths.get(subpath.toString(), new String[0]);
                projectSubpath = extractedDirectory.resolve(projectSubpath);
                if (Files.exists(projectSubpath, new LinkOption[0]) && InstallExtensionCommand._isGradleBuild(projectSubpath)) {
                    Set<Path> extensionPaths;
                    File projectSubdir = projectSubpath.toFile();
                    if (!BladeUtil.hasGradleWrapper(projectSubdir)) {
                        BladeUtil.addGradleWrapper(projectSubdir);
                    }
                    if (!quiet) {
                        bladeCLI.out("Building extension...");
                    }
                    if (!(extensionPaths = this._gradleAssemble(projectSubpath)).isEmpty()) {
                        for (Path extensionPath : extensionPaths) {
                            this._installExtension(extensionPath);
                        }
                        return;
                    } else {
                        bladeCLI.error("Unable to get output of gradle build " + projectSubpath);
                    }
                    return;
                } else {
                    bladeCLI.error("Path not a gradle build " + projectSubpath);
                }
                return;
            }
            Path tempDirecoryPath = Files.createTempDirectory(null, new FileAttribute[0]);
            try {
                File tempDirecoryFile = tempDirecoryPath.toFile();
                boolean quiet = args.isQuiet();
                if (!quiet) {
                    bladeCLI.out("Downloading github repository " + pathArg);
                }
                Path masterZipPath = BladeUtil.downloadGithubProject(pathArg, "master.zip");
                if (!quiet) {
                    bladeCLI.out("Unzipping github repository to " + tempDirecoryPath);
                }
                FileUtil.unzip(masterZipPath.toFile(), tempDirecoryFile, null);
                File[] directories = tempDirecoryFile.listFiles(File::isDirectory);
                if (directories == null || directories.length <= 0) return;
                Path directory = directories[0].toPath();
                if (InstallExtensionCommand._isGradleBuild(directory)) {
                    Set<Path> extensionPaths;
                    if (!quiet) {
                        bladeCLI.out("Building extension...");
                    }
                    if (!(extensionPaths = this._gradleAssemble(directory)).isEmpty()) {
                        for (Path extensionPath : extensionPaths) {
                            this._installExtension(extensionPath);
                        }
                        return;
                    }
                    bladeCLI.error("Unable to get output of gradle build " + directory);
                    return;
                }
                bladeCLI.error("Path not a gradle build " + directory);
                return;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                FileUtil.deleteDir(tempDirecoryPath);
            }
        }
        Path path = Paths.get(pathArg, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && (gradleBuildPath = (Path)Optional.of(path).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(InstallExtensionCommand::_isGradleBuild).orElse(null)) != null && !(paths = this._gradleAssemble(path)).isEmpty()) {
            Iterator<Path> pathsIterator = paths.iterator();
            path = pathsIterator.next();
        }
        if (path == null) {
            throw new Exception("Path to extension does not exist: " + pathArg);
        }
        this._installExtension(path);
    }

    @Override
    public Class<InstallExtensionArgs> getArgsClass() {
        return InstallExtensionArgs.class;
    }

    private static boolean _isGradleBuild(Path path) {
        return path != null && Files.exists(path.resolve("build.gradle"), new LinkOption[0]);
    }

    private Set<Path> _getExistingPaths(Map<String, Set<File>> projectOutputFiles) {
        Collection<Set<File>> values = projectOutputFiles.values();
        Stream<Set<File>> stream = values.stream();
        return stream.flatMap(files -> files.stream()).map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    private Set<Path> _gradleAssemble(Path projectPath) throws Exception {
        GradleExec gradleExec = new GradleExec(this.getBladeCLI());
        ProjectInfo projectInfo = GradleTooling.loadProjectInfo(projectPath);
        ProcessResult processResult = gradleExec.executeTask("assemble -x check", projectPath.toFile());
        int resultCode = processResult.getResultCode();
        if (resultCode > 0) {
            String output = processResult.get();
            throw new Exception("Gradle command returned error code " + resultCode + System.lineSeparator() + output);
        }
        return this._getExistingPaths(projectInfo.getProjectOutputFiles());
    }

    private void _installExtension(Path extensionPath) throws IOException {
        Path extensionName = extensionPath.getFileName();
        if (this._isExtension(extensionPath)) {
            BladeCLI bladeCLI = this.getBladeCLI();
            Path extensionsPath = bladeCLI.getExtensionsPath();
            Path extensionInstallPath = extensionsPath.resolve(extensionName);
            boolean exists = Files.exists(extensionInstallPath, new LinkOption[0]);
            String newExtensionVersion = BladeUtil.getBundleVersion(extensionPath);
            if (exists) {
                bladeCLI.out(String.format("The extension %s already exists with version %s.\n", extensionName, BladeUtil.getBundleVersion(extensionInstallPath)));
                String message = String.format("Overwrite existing extension with version %s?", newExtensionVersion);
                boolean overwrite = Prompter.confirm(message, bladeCLI.in(), bladeCLI.out(), Optional.of(false));
                if (!overwrite) {
                    return;
                }
            }
            Files.copy(extensionPath, extensionInstallPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            BaseArgs baseArgs = bladeCLI.getArgs();
            if (!baseArgs.isQuiet()) {
                bladeCLI.out(String.format("The extension %s has been installed successfully.", extensionName));
            }
        } else {
            throw new IOException(String.format("Unable to install. %s is not a valid blade extension.", extensionName));
        }
    }

    private boolean _isArchetype(Path path) {
        return BladeUtil.searchZip(path, name -> name.endsWith("archetype-metadata.xml"));
    }

    private boolean _isCustomTemplate(Path path) {
        return this._isTemplateMatch(path) && this._isArchetype(path);
    }

    private boolean _isExtension(Path path) {
        if (this._isCustomTemplate(path)) {
            return true;
        }
        return BladeUtil.searchZip(path, name -> name.startsWith("META-INF/services/com.liferay.blade.cli.command.BaseCommand"));
    }

    private boolean _isTemplateMatch(Path path) {
        return Files.exists(path, new LinkOption[0]) && (_templatePathMatcher.matches(path) || this._isArchetype(path));
    }

    private boolean _isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

