/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.CommandType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Parameters(commandDescription="Converts a plugins-sdk plugin project to a gradle WAR project in Liferay workspace", commandNames={"convert"})
public class ConvertArgs
extends BaseArgs {
    @Parameter(description="Migrate all plugin projects", names={"-a", "--all"})
    private boolean _all;
    @Parameter(description="The option for Liferay Platform product. (portal)|(dxp)", names={"--liferay-product"})
    private String _liferayProduct = "portal";
    @Parameter(description="The version of Liferay to target when converting the project. Available options are 7.0, 7.1, 7.2, 7.3, 7.4.", names={"-v", "--liferay-version"})
    private String _liferayVersion;
    @Parameter(description="List the projects available to be converted", names={"-l", "--list"})
    private boolean _list;
    @Parameter(description="[name]")
    private List<String> _name = new ArrayList<String>();
    @Parameter(description="Remove source plugin projects, default value is true", names={"-r", "--remove"})
    private boolean _removeSource = false;
    @Parameter(description="The Plugins SDK directory, otherwise default value is <workspace_dir>/plugins-sdk", names={"-s", "--source"})
    private File _source;
    @Parameter(description="Use ThemeBuilder gradle plugin instead of NodeJS to convert theme project", names={"-t", "--theme-builder"})
    private boolean _themeBuilder;

    public ConvertArgs() {
    }

    public ConvertArgs(boolean all, boolean list, boolean themeBuilder, boolean removeSource, File source, List<String> name, String product) {
        this._all = all;
        this._list = list;
        this._themeBuilder = themeBuilder;
        this._removeSource = removeSource;
        this._source = source;
        this._name = name;
        this._liferayProduct = product;
    }

    public ConvertArgs(boolean all, boolean list, boolean themeBuilder, File source, List<String> name) {
        this(all, list, themeBuilder, false, source, name, "portal");
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.WORKSPACE_ONLY;
    }

    public String getLiferayProduct() {
        return this._liferayProduct;
    }

    public String getLiferayVersion() {
        return this._liferayVersion;
    }

    public List<String> getName() {
        return this._name;
    }

    public File getSource() {
        return this._source;
    }

    public boolean isAll() {
        return this._all;
    }

    public boolean isList() {
        return this._list;
    }

    public boolean isRemoveSource() {
        return this._removeSource;
    }

    public boolean isThemeBuilder() {
        return this._themeBuilder;
    }

    public void setLiferayProduct(String liferayProduct) {
        this._liferayProduct = liferayProduct;
    }

    public void setLiferayVersion(String liferayVersion) {
        this._liferayVersion = liferayVersion;
    }
}

