/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.version.Version;

public class AetherClient {
    private static final File _DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    private static final String[] _DEFAULT_REPO_URLS = new String[]{"https://repository-cdn.liferay.com/nexus/content/groups/public"};
    private static final String _USER_HOME = System.getProperty("user.home");
    private static final File _USER_MAVEN_CONFIGURATION_HOME = new File(_USER_HOME, ".m2");
    private static final File _USER_MAVEN_DEFAULT_USER_SETTINGS_FILE = new File(_USER_MAVEN_CONFIGURATION_HOME, "settings.xml");
    private final String _localRepositoryPath;
    private final String[] _repoUrls;

    public AetherClient() {
        this(_DEFAULT_REPO_URLS);
    }

    public AetherClient(String[] repoUrls) {
        this(repoUrls, AetherClient._lookupLocalRepoDir().getPath());
    }

    public AetherClient(String[] repoUrls, String localRepositoryPath) {
        this._repoUrls = repoUrls == null ? new String[]{} : repoUrls;
        this._localRepositoryPath = localRepositoryPath;
    }

    public Artifact findLatestAvailableArtifact(String groupIdArtifactId) throws ArtifactResolutionException {
        RepositorySystem system = this._newRepositorySystem();
        List<RemoteRepository> repos = this._repos();
        String range = "[0,)";
        DefaultArtifact artifactRange = new DefaultArtifact(groupIdArtifactId + ":" + "[0,)");
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifactRange);
        rangeRequest.setRepositories(repos);
        DefaultRepositorySystemSession session = this._newRepositorySystemSession(system, this._localRepositoryPath);
        Version version = null;
        try {
            VersionRangeResult versionRangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            version = versionRangeResult.getHighestVersion();
        }
        catch (Exception versionRangeResult) {
            // empty catch block
        }
        if (version == null) {
            return null;
        }
        DefaultArtifact artifact = new DefaultArtifact(groupIdArtifactId + ":" + version);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(repos);
        ArtifactResult artifactResult = system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
        return artifactResult.getArtifact();
    }

    private static Settings _buildSettings() {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setGlobalSettingsFile(_DEFAULT_GLOBAL_SETTINGS_FILE);
        request.setUserSettingsFile(_USER_MAVEN_DEFAULT_USER_SETTINGS_FILE);
        try {
            DefaultSettingsBuilderFactory defaultSettingsBuilderFactory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder builder = defaultSettingsBuilderFactory.newInstance();
            return builder.build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException settingsBuildingException) {
            return null;
        }
    }

    private static File _lookupLocalRepoDir() {
        String localRepoPathSetting = AetherClient._buildSettings().getLocalRepository();
        if (localRepoPathSetting == null) {
            return new File(_USER_MAVEN_CONFIGURATION_HOME, "repository");
        }
        return new File(localRepoPathSetting);
    }

    private RemoteRepository _newRemoteRepository(String url) {
        return new RemoteRepository.Builder("blade", "default", url).build();
    }

    private RepositorySystem _newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        DefaultServiceLocator.ErrorHandler handler = new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        };
        locator.setErrorHandler(handler);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession _newRepositorySystemSession(RepositorySystem system, String localRepositoryPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepositoryPath);
        session.setUpdatePolicy("daily");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new NoopTransferListener());
        session.setRepositoryListener((RepositoryListener)new NoopRepositoryListener());
        return session;
    }

    private List<RemoteRepository> _repos() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (String repoUrl : this._repoUrls) {
            repos.add(this._newRemoteRepository(repoUrl));
        }
        return Collections.unmodifiableList(repos);
    }

    private static class NoopTransferListener
    extends AbstractTransferListener {
        private NoopTransferListener() {
        }
    }

    private static class NoopRepositoryListener
    extends AbstractRepositoryListener {
        private NoopRepositoryListener() {
        }
    }
}

