/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.WriteResource;
import aQute.bnd.osgi.ZipResource;
import aQute.bnd.stream.MapStream;
import aQute.bnd.version.Version;
import aQute.lib.base64.Base64;
import aQute.lib.collections.Iterables;
import aQute.lib.exceptions.BiConsumerWithException;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.io.ByteBufferOutputStream;
import aQute.lib.io.IO;
import aQute.lib.zip.ZipUtil;
import aQute.libg.cryptography.Digest;
import aQute.libg.cryptography.Digester;
import aQute.libg.cryptography.SHA256;
import aQute.libg.glob.PathSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Jar
implements Closeable {
    private static final int BUFFER_SIZE = 65536;
    private static final long ZIP_ENTRY_CONSTANT_TIME = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();
    private static final String DEFAULT_MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Pattern DEFAULT_DO_NOT_COPY = Pattern.compile("CVS|\\.svn|\\.git|\\.DS_Store|\\.gitignore");
    public static final Object[] EMPTY_ARRAY = new Jar[0];
    private final NavigableMap<String, Resource> resources = new TreeMap<String, Resource>();
    private final NavigableMap<String, Map<String, Resource>> directories = new TreeMap<String, Map<String, Resource>>();
    private Optional<Manifest> manifest;
    private Optional<ModuleAttribute> moduleAttribute;
    private boolean manifestFirst;
    private String manifestName = "META-INF/MANIFEST.MF";
    private String name;
    private File source;
    private ZipFile zipFile;
    private long lastModified;
    private String lastModifiedReason;
    private boolean doNotTouchManifest;
    private boolean nomanifest;
    private boolean reproducible;
    private Compression compression = Compression.DEFLATE;
    private boolean closed;
    private String[] algorithms;
    private SHA256 sha256;
    private boolean calculateFileDigest;
    private int fileLength = -1;
    private static final byte[] EOL = new byte[]{13, 10};
    private static final byte[] SEPARATOR = new byte[]{58, 32};
    private static final Pattern BSN = Pattern.compile("\\s*([-.\\w]+)\\s*;?.*");
    private static final Pattern SIGNER_FILES_P = Pattern.compile("(.+\\.(SF|DSA|RSA))|(.*/SIG-.*)", 2);
    private static final Predicate<String> pomXmlFilter = new PathSet(new String[]{"META-INF/maven/*/*/pom.xml"}).matches();

    public Jar(String name) {
        this.name = name;
    }

    public Jar(String name, File dirOrFile, Pattern doNotCopy) throws IOException {
        this(name);
        this.source = dirOrFile;
        if (dirOrFile.isDirectory()) {
            this.buildFromDirectory(dirOrFile.toPath().toAbsolutePath(), doNotCopy);
        } else if (dirOrFile.isFile()) {
            this.buildFromZip(dirOrFile);
        } else {
            throw new IllegalArgumentException("A Jar can only accept a file or directory that exists: " + dirOrFile);
        }
    }

    public Jar(String name, InputStream in, long lastModified) throws IOException {
        this(name, in);
    }

    public static Jar fromResource(String name, Resource resource) throws Exception {
        if (resource instanceof JarResource) {
            return ((JarResource)resource).getJar();
        }
        if (resource instanceof FileResource) {
            return new Jar(name, ((FileResource)resource).getFile());
        }
        return new Jar(name).buildFromResource(resource);
    }

    public static Stream<Resource> getResources(Resource jarResource, final Predicate<String> filter) throws Exception {
        Objects.requireNonNull(jarResource);
        Objects.requireNonNull(filter);
        if (jarResource instanceof JarResource) {
            Jar jar = ((JarResource)jarResource).getJar();
            return jar.getResources(filter);
        }
        final ZipInputStream jin = new ZipInputStream(jarResource.openInputStream());
        Spliterators.AbstractSpliterator<Resource> spliterator = new Spliterators.AbstractSpliterator<Resource>(Long.MAX_VALUE, 273){

            @Override
            public boolean tryAdvance(Consumer<? super Resource> action) {
                Objects.requireNonNull(action);
                try {
                    ZipEntry entry;
                    while ((entry = jin.getNextEntry()) != null) {
                        String path;
                        if (entry.isDirectory() || !filter.test(path = ZipUtil.cleanPath((String)entry.getName()))) continue;
                        int size = entry.getSize() < 0L ? 65536 : 1 + (int)entry.getSize();
                        try (ByteBufferOutputStream bbos = new ByteBufferOutputStream(size);){
                            bbos.write(jin);
                            EmbeddedResource resource = new EmbeddedResource(bbos.toByteBuffer(), ZipUtil.getModifiedTime((ZipEntry)entry));
                            action.accept(resource);
                        }
                        return true;
                    }
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> IO.close(jin));
    }

    public Jar(String name, String path) throws IOException {
        this(name, new File(path));
    }

    public Jar(File f) throws IOException {
        this(Jar.getName(f), f, null);
    }

    private static String getName(File f) {
        String name = (f = f.getAbsoluteFile()).getName();
        if (name.equals("bin") || name.equals("src")) {
            return f.getParentFile().getName();
        }
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    public Jar(String name, InputStream in) throws IOException {
        this(name);
        this.buildFromInputStream(in);
    }

    public Jar(String string, File file) throws IOException {
        this(string, file, DEFAULT_DO_NOT_COPY);
    }

    private Jar buildFromDirectory(final Path baseDir, final Pattern doNotCopy) throws IOException {
        Files.walkFileTree(baseDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String name;
                if (doNotCopy != null && doNotCopy.matcher(name = dir.getFileName().toString()).matches()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name;
                if (doNotCopy != null && doNotCopy.matcher(name = file.getFileName().toString()).matches()) {
                    return FileVisitResult.CONTINUE;
                }
                String relativePath = IO.normalizePath(baseDir.relativize(file));
                Jar.this.putResource(relativePath, new FileResource(file, attrs), true);
                return FileVisitResult.CONTINUE;
            }
        });
        return this;
    }

    private Jar buildFromZip(File file) throws IOException {
        try {
            this.zipFile = new ZipFile(file);
            for (ZipEntry entry : Iterables.iterable(this.zipFile.entries())) {
                if (entry.isDirectory()) continue;
                this.putResource(entry.getName(), new ZipResource(this.zipFile, entry), true);
            }
            return this;
        }
        catch (ZipException e) {
            IO.close(this.zipFile);
            ZipException ze = new ZipException("The JAR/ZIP file (" + file.getAbsolutePath() + ") seems corrupted, error: " + e.getMessage());
            ze.initCause(e);
            throw ze;
        }
        catch (FileNotFoundException e) {
            IO.close(this.zipFile);
            throw new IllegalArgumentException("Problem opening JAR: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            IO.close(this.zipFile);
            throw e;
        }
    }

    private Jar buildFromResource(Resource resource) throws Exception {
        return this.buildFromInputStream(resource.openInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Jar buildFromInputStream(InputStream in) throws IOException {
        try (ZipInputStream jin = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = jin.getNextEntry()) != null) {
                ByteBufferOutputStream bbos;
                block23: {
                    if (entry.isDirectory()) continue;
                    int size = entry.getSize() < 0L ? 65536 : 1 + (int)entry.getSize();
                    bbos = new ByteBufferOutputStream(size);
                    Throwable throwable = null;
                    try {
                        bbos.write(jin);
                        EmbeddedResource resource = new EmbeddedResource(bbos.toByteBuffer(), ZipUtil.getModifiedTime((ZipEntry)entry));
                        byte[] extra = entry.getExtra();
                        if (extra != null) {
                            resource.setExtra(Resource.encodeExtra(extra));
                        }
                        this.putResource(entry.getName(), resource, true);
                        if (bbos == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (bbos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    bbos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            bbos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        bbos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                bbos.close();
            }
            return this;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Jar:" + this.name;
    }

    public boolean putResource(String path, Resource resource) {
        return this.putResource(path, resource, true);
    }

    public boolean putResource(String path, Resource resource, boolean overwrite) {
        boolean duplicate;
        String dir;
        TreeMap<String, Resource> s;
        this.check();
        path = ZipUtil.cleanPath((String)path);
        if (path.equals(this.manifestName)) {
            this.manifest = null;
            if (this.resources.isEmpty()) {
                this.manifestFirst = true;
            }
        } else if (path.equals("module-info.class")) {
            this.moduleAttribute = null;
        }
        if ((s = (TreeMap<String, Resource>)this.directories.get(dir = this.getParent(path))) == null) {
            int n;
            s = new TreeMap<String, Resource>();
            this.directories.put(dir, s);
            while ((n = dir.lastIndexOf(47)) > 0 && !this.directories.containsKey(dir = dir.substring(0, n))) {
                this.directories.put(dir, null);
            }
        }
        if (!(duplicate = s.containsKey(path)) || overwrite) {
            this.resources.put(path, resource);
            s.put(path, resource);
            this.updateModified(resource.lastModified(), path);
        }
        return duplicate;
    }

    public Resource getResource(String path) {
        this.check();
        path = ZipUtil.cleanPath((String)path);
        return (Resource)this.resources.get(path);
    }

    public Stream<String> getResourceNames(Predicate<String> matches) {
        return this.getResources().keySet().stream().filter(matches);
    }

    public Stream<Resource> getResources(Predicate<String> matches) {
        return this.getResourceNames(matches).map(this.resources::get);
    }

    private String getParent(String path) {
        this.check();
        int n = path.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return path.substring(0, n);
    }

    public Map<String, Map<String, Resource>> getDirectories() {
        this.check();
        return this.directories;
    }

    public Map<String, Resource> getDirectory(String path) {
        this.check();
        path = ZipUtil.cleanPath((String)path);
        return (Map)this.directories.get(path);
    }

    public Map<String, Resource> getResources() {
        this.check();
        return this.resources;
    }

    public boolean addDirectory(Map<String, Resource> directory, boolean overwrite) {
        this.check();
        boolean duplicates = false;
        if (directory == null) {
            return false;
        }
        for (Map.Entry<String, Resource> entry : directory.entrySet()) {
            duplicates |= this.putResource(entry.getKey(), entry.getValue(), overwrite);
        }
        return duplicates;
    }

    public Manifest getManifest() throws Exception {
        return this.manifest().orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<Manifest> manifest() {
        this.check();
        Optional<Manifest> optional = this.manifest;
        if (optional != null) {
            return optional;
        }
        try {
            Resource manifestResource = this.getResource(this.manifestName);
            if (manifestResource == null) {
                this.manifest = Optional.empty();
                return this.manifest;
            }
            try (InputStream in = manifestResource.openInputStream();){
                this.manifest = Optional.of(new Manifest(in));
                Optional<Manifest> optional2 = this.manifest;
                return optional2;
            }
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
    }

    Optional<ModuleAttribute> moduleAttribute() throws Exception {
        ClassFile module_info;
        this.check();
        Optional<ModuleAttribute> optional = this.moduleAttribute;
        if (optional != null) {
            return optional;
        }
        Resource module_info_resource = this.getResource("module-info.class");
        if (module_info_resource == null) {
            this.moduleAttribute = Optional.empty();
            return this.moduleAttribute;
        }
        ByteBuffer bb = module_info_resource.buffer();
        if (bb != null) {
            module_info = ClassFile.parseClassFile((DataInput)ByteBufferDataInput.wrap(bb));
        } else {
            try (DataInputStream din = new DataInputStream(module_info_resource.openInputStream());){
                module_info = ClassFile.parseClassFile((DataInput)din);
            }
        }
        this.moduleAttribute = Arrays.stream(module_info.attributes).filter(ModuleAttribute.class::isInstance).map(ModuleAttribute.class::cast).findFirst();
        return this.moduleAttribute;
    }

    public String getModuleName() throws Exception {
        return this.moduleAttribute().map(a -> a.module_name).orElseGet(this::automaticModuleName);
    }

    String automaticModuleName() {
        return this.manifest().map(m -> m.getMainAttributes().getValue("Automatic-Module-Name")).orElse(null);
    }

    public String getModuleVersion() throws Exception {
        return this.moduleAttribute().map(a -> a.module_version).orElse(null);
    }

    public boolean exists(String path) {
        this.check();
        path = ZipUtil.cleanPath((String)path);
        return this.resources.containsKey(path);
    }

    public boolean isEmpty() {
        this.check();
        return this.resources.isEmpty();
    }

    public void setManifest(Manifest manifest) {
        this.check();
        this.manifestFirst = true;
        this.manifest = Optional.ofNullable(manifest);
    }

    public void setManifest(File file) throws IOException {
        this.check();
        try (InputStream fin = IO.stream(file);){
            Manifest m = new Manifest(fin);
            this.setManifest(m);
        }
    }

    public void setManifestName(String manifestName) {
        this.check();
        manifestName = ZipUtil.cleanPath((String)manifestName);
        if (manifestName.isEmpty()) {
            throw new IllegalArgumentException("Manifest name must not be empty");
        }
        this.manifestName = manifestName;
    }

    public void write(File file) throws Exception {
        this.check();
        try (OutputStream out = IO.outputStream(file);){
            this.write(out);
        }
        catch (Exception t) {
            IO.delete(file);
            throw t;
        }
        file.setLastModified(this.lastModified());
    }

    public void write(String file) throws Exception {
        this.check();
        this.write(new File(file));
    }

    public void write(OutputStream to) throws Exception {
        this.check();
        if (!this.doNotTouchManifest && !this.nomanifest && this.algorithms != null) {
            this.doChecksums(to);
            return;
        }
        OutputStream out = to;
        Digester digester = null;
        this.sha256 = null;
        this.fileLength = -1;
        if (this.calculateFileDigest) {
            digester = SHA256.getDigester((OutputStream[])new OutputStream[]{out});
            out = digester;
        }
        ZipOutputStream jout = this.nomanifest || this.doNotTouchManifest ? new ZipOutputStream(out) : new JarOutputStream(out);
        switch (this.compression) {
            case STORE: {
                jout.setMethod(0);
                break;
            }
        }
        HashSet<String> done = new HashSet<String>();
        HashSet<String> directories = new HashSet<String>();
        if (this.doNotTouchManifest) {
            Resource r = this.getResource(this.manifestName);
            if (r != null) {
                this.writeResource(jout, directories, this.manifestName, r);
                done.add(this.manifestName);
            }
        } else if (!this.nomanifest) {
            this.doManifest(jout, directories, this.manifestName);
            done.add(this.manifestName);
        }
        for (Map.Entry<String, Resource> entry : this.getResources().entrySet()) {
            if (done.contains(entry.getKey())) continue;
            this.writeResource(jout, directories, entry.getKey(), entry.getValue());
        }
        jout.finish();
        if (digester != null) {
            this.sha256 = (SHA256)digester.digest();
            this.fileLength = digester.getLength();
        }
    }

    public void writeFolder(File dir) throws Exception {
        IO.mkdirs(dir);
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory " + dir + " to write the JAR " + this + " could not be created");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The directory " + dir + " to write the JAR " + this + " to is not a directory");
        }
        this.check();
        HashSet<String> done = new HashSet<String>();
        if (this.doNotTouchManifest) {
            Resource r = this.getResource(this.manifestName);
            if (r != null) {
                this.copyResource(dir, this.manifestName, r);
                done.add(this.manifestName);
            }
        } else {
            File file = IO.getBasedFile(dir, this.manifestName);
            IO.mkdirs(file.getParentFile());
            try (OutputStream fout = IO.outputStream(file);){
                this.writeManifest(fout);
                done.add(this.manifestName);
            }
        }
        for (Map.Entry<String, Resource> entry : this.getResources().entrySet()) {
            String path = entry.getKey();
            if (done.contains(path)) continue;
            Resource resource = entry.getValue();
            this.copyResource(dir, path, resource);
        }
    }

    private void copyResource(File dir, String path, Resource resource) throws Exception {
        File to = IO.getBasedFile(dir, path);
        IO.mkdirs(to.getParentFile());
        IO.copy(resource.openInputStream(), to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChecksums(OutputStream out) throws Exception {
        String[] algs = this.algorithms;
        this.algorithms = null;
        try {
            File f = File.createTempFile(this.padString(this.getName(), 3, '_'), ".jar");
            this.write(f);
            try (Jar tmp = new Jar(f);){
                tmp.setCompression(this.compression);
                tmp.calcChecksums(algs);
                tmp.write(out);
            }
            finally {
                IO.delete(f);
            }
        }
        finally {
            this.algorithms = algs;
        }
    }

    private String padString(String s, int length, char pad) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= length) {
            return s;
        }
        char[] cs = new char[length];
        Arrays.fill(cs, pad);
        char[] orig = s.toCharArray();
        System.arraycopy(orig, 0, cs, 0, orig.length);
        return new String(cs);
    }

    private void doManifest(ZipOutputStream jout, Set<String> directories, String manifestName) throws Exception {
        this.check();
        this.createDirectories(directories, jout, manifestName);
        JarEntry ze = new JarEntry(manifestName);
        if (this.isReproducible()) {
            ze.setTime(ZIP_ENTRY_CONSTANT_TIME);
        } else {
            ZipUtil.setModifiedTime((ZipEntry)ze, (long)this.lastModified());
        }
        WriteResource r = new WriteResource(){

            @Override
            public void write(OutputStream out) throws Exception {
                Jar.this.writeManifest(out);
            }

            @Override
            public long lastModified() {
                return 0L;
            }
        };
        this.putEntry(jout, ze, r);
    }

    private void putEntry(ZipOutputStream jout, ZipEntry entry, Resource r) throws Exception {
        if (this.compression == Compression.STORE) {
            byte[] content = IO.read(r.openInputStream());
            entry.setMethod(0);
            CRC32 crc = new CRC32();
            crc.update(content);
            entry.setCrc(crc.getValue());
            entry.setSize(content.length);
            entry.setCompressedSize(content.length);
            jout.putNextEntry(entry);
            jout.write(content);
        } else {
            jout.putNextEntry(entry);
            r.write(jout);
        }
        jout.closeEntry();
    }

    public void writeManifest(OutputStream out) throws Exception {
        this.check();
        this.stripSignatures();
        Jar.writeManifest(this.getManifest(), out);
    }

    public static void writeManifest(Manifest manifest, OutputStream out) throws IOException {
        if (manifest == null) {
            return;
        }
        manifest = Jar.clean(manifest);
        Jar.outputManifest(manifest, out);
    }

    public static void outputManifest(Manifest manifest, OutputStream out) throws IOException {
        Jar.writeEntry(out, "Manifest-Version", "1.0");
        Jar.attributes(manifest.getMainAttributes(), out);
        out.write(EOL);
        TreeSet<String> keys = new TreeSet<String>();
        for (String o : manifest.getEntries().keySet()) {
            keys.add(o.toString());
        }
        for (String key : keys) {
            Jar.writeEntry(out, "Name", key);
            Jar.attributes(manifest.getAttributes(key), out);
            out.write(EOL);
        }
        out.flush();
    }

    private static void writeEntry(OutputStream out, String name, String value) throws IOException {
        int width = Jar.write(out, 0, name);
        width = Jar.write(out, width, SEPARATOR);
        Jar.write(out, width, value);
        out.write(EOL);
    }

    private static int write(OutputStream out, int width, String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return Jar.write(out, width, bytes);
    }

    private static int write(OutputStream out, int width, byte[] bytes) throws IOException {
        int w = width;
        for (byte b : bytes) {
            if (w >= 72 - EOL.length) {
                out.write(EOL);
                out.write(32);
                w = 1;
            }
            out.write(b);
            ++w;
        }
        return w;
    }

    private static void attributes(Attributes value, OutputStream out) throws IOException {
        MapStream.of((Map)value).map((k, v) -> MapStream.entry((Object)k.toString(), (Object)v.toString())).filterKey(k -> !k.equals("Manifest-Version")).sortedByKey(String.CASE_INSENSITIVE_ORDER).forEachOrdered(BiConsumerWithException.asBiConsumer((k, v) -> Jar.writeEntry(out, k, v)));
    }

    private static Manifest clean(Manifest org) {
        Manifest result = new Manifest();
        for (Map.Entry<Object, Object> entry : org.getMainAttributes().entrySet()) {
            String nice = Jar.clean((String)entry.getValue());
            result.getMainAttributes().put(entry.getKey(), nice);
        }
        for (String name : org.getEntries().keySet()) {
            Attributes attrs = result.getAttributes(name);
            if (attrs == null) {
                attrs = new Attributes();
                result.getEntries().put(name, attrs);
            }
            for (Map.Entry<Object, Object> entry : org.getAttributes(name).entrySet()) {
                String nice = Jar.clean((String)entry.getValue());
                attrs.put(entry.getKey(), nice);
            }
        }
        return result;
    }

    private static String clean(String s) {
        StringBuilder sb = new StringBuilder(s);
        boolean changed = false;
        boolean replacedPrev = false;
        block3: for (int i = 0; i < sb.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    changed = true;
                    if (!replacedPrev) {
                        sb.replace(i, i + 1, " ");
                        replacedPrev = true;
                        continue block3;
                    }
                    sb.delete(i, i + 1);
                    continue block3;
                }
                default: {
                    replacedPrev = false;
                }
            }
        }
        if (changed) {
            return sb.toString();
        }
        return s;
    }

    private void writeResource(ZipOutputStream jout, Set<String> directories, String path, Resource resource) throws Exception {
        if (resource == null) {
            return;
        }
        try {
            this.createDirectories(directories, jout, path);
            if (path.endsWith("<<EMPTY>>")) {
                return;
            }
            ZipEntry ze = new ZipEntry(path);
            ze.setMethod(8);
            if (this.isReproducible()) {
                ze.setTime(ZIP_ENTRY_CONSTANT_TIME);
            } else {
                long lastModified = resource.lastModified();
                if (lastModified == 0L) {
                    lastModified = System.currentTimeMillis();
                }
                ZipUtil.setModifiedTime((ZipEntry)ze, (long)lastModified);
            }
            String extra = resource.getExtra();
            if (extra != null) {
                ze.setExtra(Resource.decodeExtra(extra));
            }
            this.putEntry(jout, ze, resource);
        }
        catch (Exception e) {
            throw new Exception("Problem writing resource " + path, e);
        }
    }

    void createDirectories(Set<String> directories, ZipOutputStream zip, String name) throws IOException {
        int index = name.lastIndexOf(47);
        if (index > 0) {
            String path = name.substring(0, index);
            if (directories.contains(path)) {
                return;
            }
            this.createDirectories(directories, zip, path);
            ZipEntry ze = new ZipEntry(path + '/');
            if (this.isReproducible()) {
                ze.setTime(ZIP_ENTRY_CONSTANT_TIME);
            } else {
                ZipUtil.setModifiedTime((ZipEntry)ze, (long)this.lastModified());
            }
            if (this.compression == Compression.STORE) {
                ze.setCrc(0L);
                ze.setSize(0L);
                ze.setCompressedSize(0L);
            }
            zip.putNextEntry(ze);
            zip.closeEntry();
            directories.add(path);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean addAll(Jar sub, Instruction filter) {
        return this.addAll(sub, filter, "");
    }

    public boolean addAll(Jar sub, Instruction filter, String destination) {
        this.check();
        boolean dupl = false;
        for (String name : sub.getResources().keySet()) {
            if (this.manifestName.equals(name) || filter != null && !(filter.matches(name) ^ filter.isNegated())) continue;
            dupl |= this.putResource(Processor.appendPath(destination, name), sub.getResource(name), true);
        }
        return dupl;
    }

    @Override
    public void close() {
        this.closed = true;
        IO.close(this.zipFile);
        this.resources.values().forEach(IO::close);
        this.resources.clear();
        this.directories.clear();
        this.manifest = null;
        this.source = null;
    }

    public long lastModified() {
        return this.lastModified;
    }

    String lastModifiedReason() {
        return this.lastModifiedReason;
    }

    public void updateModified(long time, String reason) {
        if (time > this.lastModified) {
            this.lastModified = time;
            this.lastModifiedReason = reason;
        }
    }

    public boolean hasDirectory(String path) {
        this.check();
        path = ZipUtil.cleanPath((String)path);
        return this.directories.containsKey(path);
    }

    public List<String> getPackages() {
        this.check();
        return MapStream.of(this.directories).filterValue(mdir -> Objects.nonNull(mdir) && !mdir.isEmpty()).keys().map(k -> k.replace('/', '.')).collect(Collectors.toList());
    }

    public File getSource() {
        this.check();
        return this.source;
    }

    public boolean addAll(Jar src) {
        this.check();
        return this.addAll(src, null);
    }

    public boolean rename(String oldPath, String newPath) {
        this.check();
        Resource resource = this.remove(oldPath);
        if (resource == null) {
            return false;
        }
        return this.putResource(newPath, resource);
    }

    public Resource remove(String path) {
        this.check();
        path = ZipUtil.cleanPath((String)path);
        Resource resource = (Resource)this.resources.remove(path);
        if (resource != null) {
            String dir = this.getParent(path);
            Map mdir = (Map)this.directories.get(dir);
            mdir.remove(path);
        }
        return resource;
    }

    public void setDoNotTouchManifest() {
        this.doNotTouchManifest = true;
    }

    public void calcChecksums(String[] algorithms) throws Exception {
        Manifest m;
        this.check();
        if (algorithms == null) {
            algorithms = new String[]{"SHA1", "MD5"};
        }
        if ((m = this.getManifest()) == null) {
            m = new Manifest();
            this.setManifest(m);
        }
        MessageDigest[] digests = new MessageDigest[algorithms.length];
        int n = 0;
        for (String algorithm : algorithms) {
            digests[n++] = MessageDigest.getInstance(algorithm);
        }
        byte[] buffer = new byte[65536];
        for (Map.Entry entry : this.resources.entrySet()) {
            Resource r;
            ByteBuffer bb;
            String path = (String)entry.getKey();
            if (path.equals(this.manifestName)) continue;
            Attributes attributes = m.getAttributes(path);
            if (attributes == null) {
                attributes = new Attributes();
                this.getManifest().getEntries().put(path, attributes);
            }
            if ((bb = (r = (Resource)entry.getValue()).buffer()) != null && bb.hasArray()) {
                for (MessageDigest messageDigest : digests) {
                    messageDigest.update(bb);
                    bb.flip();
                }
            } else {
                try (InputStream in = r.openInputStream();){
                    int size;
                    while ((size = in.read(buffer, 0, buffer.length)) > 0) {
                        for (MessageDigest d2 : digests) {
                            d2.update(buffer, 0, size);
                        }
                    }
                }
            }
            for (MessageDigest messageDigest : digests) {
                attributes.putValue(messageDigest.getAlgorithm() + "-Digest", Base64.encodeBase64((byte[])messageDigest.digest()));
                messageDigest.reset();
            }
        }
    }

    public String getBsn() throws Exception {
        return this.manifest().map(m -> m.getMainAttributes().getValue("Bundle-SymbolicName")).map(s -> {
            Matcher matcher = BSN.matcher((CharSequence)s);
            return matcher.matches() ? matcher.group(1) : null;
        }).orElse(null);
    }

    public String getVersion() throws Exception {
        return this.manifest().map(m -> m.getMainAttributes().getValue("Bundle-Version")).map(String::trim).orElse(null);
    }

    public void expand(File dir) throws Exception {
        this.writeFolder(dir);
    }

    public void ensureManifest() throws Exception {
        if (!this.manifest().isPresent()) {
            this.manifest = Optional.of(new Manifest());
        }
    }

    public boolean isManifestFirst() {
        return this.manifestFirst;
    }

    public boolean isReproducible() {
        return this.reproducible;
    }

    public void setReproducible(boolean reproducible) {
        this.reproducible = reproducible;
    }

    public void copy(Jar srce, String path, boolean overwrite) {
        this.check();
        this.addDirectory(srce.getDirectory(path), overwrite);
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Compression hasCompression() {
        return this.compression;
    }

    void check() {
        if (this.closed) {
            throw new RuntimeException("Already closed " + this.name);
        }
    }

    public URI getDataURI(String path, String mime, int max) throws Exception {
        Resource r = this.getResource(path);
        if (r.size() >= (long)max || r.size() <= 0L) {
            return null;
        }
        byte[] data = new byte[(int)r.size()];
        try (DataInputStream din = new DataInputStream(r.openInputStream());){
            din.readFully(data);
            String encoded = Base64.encodeBase64((byte[])data);
            URI uRI = new URI("data:" + mime + ";base64," + encoded);
            return uRI;
        }
    }

    public void setDigestAlgorithms(String[] algorithms) {
        this.algorithms = algorithms;
    }

    public byte[] getTimelessDigest() throws Exception {
        this.check();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        DigestOutputStream dout = new DigestOutputStream(IO.nullStream, md);
        Manifest m = this.getManifest();
        if (m != null) {
            Manifest m2 = new Manifest(m);
            Attributes main = m2.getMainAttributes();
            String lastmodified = (String)main.remove(new Attributes.Name("Bnd-LastModified"));
            String version = main.getValue(new Attributes.Name("Bundle-Version"));
            if (version != null && Verifier.isVersion(version)) {
                Version v = new Version(version);
                main.putValue("Bundle-Version", v.toStringWithoutQualifier());
            }
            Jar.writeManifest(m2, dout);
            for (Map.Entry<String, Resource> entry : this.getResources().entrySet()) {
                String path = entry.getKey();
                if (path.equals(this.manifestName)) continue;
                Resource resource = entry.getValue();
                ((OutputStream)dout).write(path.getBytes(StandardCharsets.UTF_8));
                resource.write(dout);
            }
        }
        return md.digest();
    }

    public void stripSignatures() {
        Map<String, Resource> map = this.getDirectory("META-INF");
        if (map != null) {
            for (String file : new HashSet<String>(map.keySet())) {
                if (!SIGNER_FILES_P.matcher(file).matches()) continue;
                this.remove(file);
            }
        }
    }

    public void removePrefix(String prefixLow) {
        prefixLow = ZipUtil.cleanPath((String)prefixLow);
        String prefixHigh = prefixLow.concat("\uffff");
        this.resources.subMap(prefixLow, prefixHigh).clear();
        if (prefixLow.endsWith("/")) {
            prefixLow = prefixLow.substring(0, prefixLow.length() - 1);
            prefixHigh = prefixLow.concat("\uffff");
        }
        this.directories.subMap(prefixLow, prefixHigh).clear();
    }

    public void removeSubDirs(String dir) {
        if (!(dir = ZipUtil.cleanPath((String)dir)).endsWith("/")) {
            dir = dir.concat("/");
        }
        ArrayList<String> subDirs = new ArrayList<String>(this.directories.subMap(dir, dir.concat("\uffff")).keySet());
        subDirs.forEach(subDir -> this.removePrefix(subDir.concat("/")));
    }

    public Stream<Resource> getPomXmlResources() {
        return this.getResources(pomXmlFilter);
    }

    public Jar setCalculateFileDigest(boolean onOrOff) {
        this.calculateFileDigest = onOrOff;
        return this;
    }

    public Optional<byte[]> getSHA256() {
        return Optional.ofNullable(this.sha256).map(Digest::digest);
    }

    public int getLength() {
        return this.fileLength;
    }

    public static enum Compression {
        DEFLATE,
        STORE;

    }
}

