/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Constants;
import aQute.bnd.service.result.Result;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.libg.generics.Create;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

public class Descriptors {
    private final Map<String, TypeRef> typeRefCache = new HashMap<String, TypeRef>();
    private final Map<String, Descriptor> descriptorCache = new HashMap<String, Descriptor>();
    private final Map<String, PackageRef> packageRefCache = new HashMap<String, PackageRef>();
    private final Map<String, ClassSignature> classSignatureCache = new HashMap<String, ClassSignature>();
    private final Map<String, MethodSignature> methodSignatureCache = new HashMap<String, MethodSignature>();
    private final Map<String, FieldSignature> fieldSignatureCache = new HashMap<String, FieldSignature>();
    static final PackageRef DEFAULT_PACKAGE = new PackageRef();
    static final PackageRef PRIMITIVE_PACKAGE = new PackageRef();
    static final TypeRef VOID = new ConcreteRef("V", "void", PRIMITIVE_PACKAGE);
    static final TypeRef BOOLEAN = new ConcreteRef("Z", "boolean", PRIMITIVE_PACKAGE);
    static final TypeRef BYTE = new ConcreteRef("B", "byte", PRIMITIVE_PACKAGE);
    static final TypeRef CHAR = new ConcreteRef("C", "char", PRIMITIVE_PACKAGE);
    static final TypeRef SHORT = new ConcreteRef("S", "short", PRIMITIVE_PACKAGE);
    static final TypeRef INTEGER = new ConcreteRef("I", "int", PRIMITIVE_PACKAGE);
    static final TypeRef LONG = new ConcreteRef("J", "long", PRIMITIVE_PACKAGE);
    static final TypeRef DOUBLE = new ConcreteRef("D", "double", PRIMITIVE_PACKAGE);
    static final TypeRef FLOAT = new ConcreteRef("F", "float", PRIMITIVE_PACKAGE);

    public Descriptors() {
        this.packageRefCache.put(DEFAULT_PACKAGE.getBinary(), DEFAULT_PACKAGE);
    }

    public TypeRef getTypeRef(String binaryClassName) {
        assert (!binaryClassName.endsWith(".class"));
        int last = binaryClassName.length() - 1;
        if (last > 0 && binaryClassName.charAt(0) == 'L' && binaryClassName.charAt(last) == ';') {
            binaryClassName = binaryClassName.substring(1, last);
            last -= 2;
        }
        binaryClassName = binaryClassName.replace('.', '$');
        if (last >= 0 && binaryClassName.charAt(0) == '[') {
            TypeRef ref = this.typeRefCache.get(binaryClassName);
            if (ref == null) {
                ref = new ArrayRef(this.getTypeRef(binaryClassName.substring(1)));
                this.typeRefCache.put(binaryClassName, ref);
            }
            return ref;
        }
        return this.typeRefCache.computeIfAbsent(binaryClassName, this::createTypeRef);
    }

    private TypeRef createTypeRef(String binaryClassName) {
        int n;
        if (binaryClassName.length() == 1) {
            switch (binaryClassName.charAt(0)) {
                case 'V': {
                    return VOID;
                }
                case 'B': {
                    return BYTE;
                }
                case 'C': {
                    return CHAR;
                }
                case 'I': {
                    return INTEGER;
                }
                case 'S': {
                    return SHORT;
                }
                case 'D': {
                    return DOUBLE;
                }
                case 'F': {
                    return FLOAT;
                }
                case 'J': {
                    return LONG;
                }
                case 'Z': {
                    return BOOLEAN;
                }
            }
        }
        PackageRef pref = (n = binaryClassName.lastIndexOf(47)) < 0 ? DEFAULT_PACKAGE : this.getPackageRef(binaryClassName.substring(0, n));
        return new ConcreteRef(pref, binaryClassName);
    }

    public TypeRef getPackageInfo(PackageRef packageRef) {
        String bin = packageRef.getBinary().concat("/package-info");
        return this.getTypeRef(bin);
    }

    public PackageRef getPackageRef(String binaryPackName) {
        binaryPackName = Descriptors.fqnToBinary(binaryPackName);
        return this.packageRefCache.computeIfAbsent(binaryPackName, PackageRef::new);
    }

    public Descriptor getDescriptor(String descriptor) {
        return this.descriptorCache.computeIfAbsent(descriptor, x$0 -> new Descriptor((String)x$0));
    }

    public ClassSignature getClassSignature(String signature) {
        return this.classSignatureCache.computeIfAbsent(signature.replace('$', '.'), ClassSignature::of);
    }

    public MethodSignature getMethodSignature(String signature) {
        return this.methodSignatureCache.computeIfAbsent(signature.replace('$', '.'), MethodSignature::of);
    }

    public FieldSignature getFieldSignature(String signature) {
        return this.fieldSignatureCache.computeIfAbsent(signature.replace('$', '.'), FieldSignature::of);
    }

    public static String getShortName(String fqn) {
        assert (fqn.indexOf(47) < 0);
        int n = fqn.lastIndexOf(46);
        if (n >= 0) {
            return fqn.substring(n + 1);
        }
        return fqn;
    }

    public static String binaryToFQN(String binary) {
        assert (!binary.isEmpty());
        return binary.replace('/', '.');
    }

    public static String binaryClassToFQN(String path) {
        return Descriptors.binaryToFQN(path.substring(0, path.length() - 6)).replace('$', '.');
    }

    public static String fqnToBinary(String fqn) {
        return fqn.replace('.', '/');
    }

    public static String fqnClassToBinary(String fqn) {
        Result<String[], String> result = Descriptors.determine(fqn);
        if (result.isErr()) {
            throw new IllegalArgumentException(result.error().orElse("Error in fqn: " + fqn));
        }
        String[] parts = (String[])result.unwrap();
        if (parts[0] == null) {
            return Descriptors.classToPath(parts[1]);
        }
        if (parts[1] == null) {
            return Descriptors.fqnToBinary(parts[0]) + ".class";
        }
        return Descriptors.fqnToBinary(parts[0]) + "/" + Descriptors.classToPath(parts[1]);
    }

    public static String classToPath(String className) {
        return className.replace('.', '$') + ".class";
    }

    public static String getPackage(String binaryNameOrFqn) {
        int n = binaryNameOrFqn.lastIndexOf(47);
        if (n >= 0) {
            return Descriptors.binaryToFQN(binaryNameOrFqn.substring(0, n));
        }
        n = binaryNameOrFqn.lastIndexOf(46);
        if (n >= 0) {
            return binaryNameOrFqn.substring(0, n);
        }
        return DEFAULT_PACKAGE.getFQN();
    }

    public static String fqnToPath(String s) {
        return Descriptors.fqnToBinary(s).concat(".class");
    }

    public TypeRef getTypeRefFromFQN(String fqn) {
        switch (fqn) {
            case "boolean": {
                return BOOLEAN;
            }
            case "byte": {
                return BOOLEAN;
            }
            case "char": {
                return CHAR;
            }
            case "short": {
                return SHORT;
            }
            case "int": {
                return INTEGER;
            }
            case "long": {
                return LONG;
            }
            case "float": {
                return FLOAT;
            }
            case "double": {
                return DOUBLE;
            }
        }
        return this.getTypeRef(Descriptors.fqnToBinary(fqn));
    }

    public TypeRef getTypeRefFromPath(String path) {
        assert (path.endsWith(".class"));
        return this.getTypeRef(path.substring(0, path.length() - 6));
    }

    public static String pathToFqn(String path) {
        assert (path.endsWith(".class"));
        StringBuilder sb = new StringBuilder();
        int j = path.length() - 6;
        for (int i = 0; i < j; ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isBinaryClass(String resource) {
        return resource.endsWith(".class");
    }

    public static String binaryToSimple(String resource) {
        int end;
        if (resource == null) {
            return null;
        }
        assert (Descriptors.isBinaryClass(resource));
        for (int rover = end = resource.length() - 6; rover >= 0; --rover) {
            char ch = resource.charAt(rover);
            if (ch != '$' && ch != '/') continue;
            return resource.substring(rover + 1, end);
        }
        return resource.substring(0, end);
    }

    public static boolean isClassName(String fqn) {
        if (fqn.isEmpty()) {
            return false;
        }
        int n = fqn.lastIndexOf(46) + 1;
        if (n >= fqn.length()) {
            return false;
        }
        char ch = fqn.charAt(n);
        return Character.isUpperCase(ch);
    }

    public static Result<String[], String> determine(String fqn) {
        int cp;
        if (fqn == null || fqn.isEmpty()) {
            return Result.err((String)"No qualified name given (either null or empty) %s", (Object[])new Object[]{fqn});
        }
        int len = fqn.length();
        int cstart = -1;
        boolean start = true;
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(fqn, i);
            if (start) {
                if (!Character.isJavaIdentifierStart(cp)) {
                    return Result.err((String)"Could not match %s to a qualified Java Identifier :: package? classname", (Object[])new Object[]{fqn});
                }
                if (Character.isUpperCase(cp)) {
                    cstart = i;
                    break;
                }
                start = false;
                continue;
            }
            if (cp == 46) {
                start = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(cp)) continue;
            return Result.err((String)"Could not match %s to a qualified Java Identifier :: package? classname, char %s", (Object[])new Object[]{fqn, i});
        }
        String[] result = new String[2];
        if (cstart == 0) {
            result[1] = fqn;
        } else if (cstart > 0) {
            result[0] = fqn.substring(0, cstart - 1);
            result[1] = fqn.substring(cstart);
        } else {
            result[0] = fqn;
        }
        return Result.ok((Object)result);
    }

    public class Descriptor {
        final TypeRef type;
        final TypeRef[] prototype;
        final String descriptor;

        Descriptor(String descriptor) {
            this.descriptor = descriptor;
            int index = 0;
            List<TypeRef> types = Create.list();
            if (descriptor.charAt(index) == '(') {
                ++index;
                while (descriptor.charAt(index) != ')') {
                    index = this.parse(types, descriptor, index);
                }
                ++index;
                this.prototype = types.toArray(new TypeRef[0]);
                types.clear();
            } else {
                this.prototype = null;
            }
            index = this.parse(types, descriptor, index);
            this.type = types.get(0);
        }

        int parse(List<TypeRef> types, String descriptor, int index) {
            char c;
            StringBuilder sb = new StringBuilder();
            while ((c = descriptor.charAt(index++)) == '[') {
                sb.append('[');
            }
            switch (c) {
                case 'L': {
                    while ((c = descriptor.charAt(index++)) != ';') {
                        sb.append(c);
                    }
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    sb.append(c);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type in descriptor: " + c + " from " + descriptor + "[" + index + "]");
                }
            }
            types.add(Descriptors.this.getTypeRef(sb.toString()));
            return index;
        }

        public TypeRef getType() {
            return this.type;
        }

        public TypeRef[] getPrototype() {
            return this.prototype;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            return Arrays.equals(this.prototype, ((Descriptor)other).prototype) && this.type == ((Descriptor)other).type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.type.hashCode();
            result = 31 * result + (this.prototype == null ? 0 : Arrays.hashCode(this.prototype));
            return result;
        }

        public String toString() {
            return this.descriptor;
        }
    }

    private static class ArrayRef
    implements TypeRef {
        final TypeRef component;

        ArrayRef(TypeRef component) {
            this.component = Objects.requireNonNull(component);
        }

        @Override
        public String getBinary() {
            return "[".concat(this.component.getBinary());
        }

        @Override
        public String getFQN() {
            return this.component.getFQN().concat("[]");
        }

        @Override
        public String getPath() {
            return this.component.getPath();
        }

        @Override
        public String getSourcePath() {
            return this.component.getSourcePath();
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public TypeRef getComponentTypeRef() {
            return this.component;
        }

        @Override
        public TypeRef getClassRef() {
            return this.component.getClassRef();
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            return this.component.equals(((ArrayRef)other).component);
        }

        @Override
        public PackageRef getPackageRef() {
            return this.component.getPackageRef();
        }

        @Override
        public String getShortName() {
            return this.component.getShortName().concat("[]");
        }

        @Override
        public boolean isJava() {
            return this.component.isJava();
        }

        public String toString() {
            return this.component.toString().concat("[]");
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public String getDottedOnly() {
            return this.component.getDottedOnly();
        }

        @Override
        public int compareTo(TypeRef other) {
            if (this == other) {
                return 0;
            }
            return this.getFQN().compareTo(other.getFQN());
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String getShorterName() {
            String name = this.getShortName();
            int n = name.lastIndexOf(36);
            if (n <= 0) {
                return name;
            }
            return name.substring(n + 1);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public boolean isNested() {
            return this.component.isNested();
        }
    }

    private static class ConcreteRef
    implements TypeRef {
        final String binaryName;
        final String fqn;
        final boolean primitive;
        final PackageRef packageRef;

        ConcreteRef(PackageRef packageRef, String binaryName) {
            this.binaryName = Objects.requireNonNull(binaryName);
            this.fqn = Descriptors.binaryToFQN(binaryName);
            this.primitive = false;
            this.packageRef = Objects.requireNonNull(packageRef);
        }

        ConcreteRef(String binaryName, String fqn, PackageRef packageRef) {
            this.binaryName = binaryName;
            this.fqn = fqn;
            this.primitive = true;
            this.packageRef = packageRef;
        }

        @Override
        public String getBinary() {
            return this.binaryName;
        }

        @Override
        public String getPath() {
            return this.binaryName.concat(".class");
        }

        @Override
        public String getSourcePath() {
            return this.binaryName.concat(".java");
        }

        @Override
        public String getFQN() {
            return this.fqn;
        }

        @Override
        public String getDottedOnly() {
            return this.fqn.replace('$', '.');
        }

        @Override
        public boolean isPrimitive() {
            return this.primitive;
        }

        @Override
        public TypeRef getComponentTypeRef() {
            return null;
        }

        @Override
        public TypeRef getClassRef() {
            return this;
        }

        @Override
        public PackageRef getPackageRef() {
            return this.packageRef;
        }

        @Override
        public String getShortName() {
            int n = this.binaryName.lastIndexOf(47);
            return this.binaryName.substring(n + 1);
        }

        @Override
        public String getShorterName() {
            String name = this.getShortName();
            int n = name.lastIndexOf(36);
            if (n <= 0) {
                return name;
            }
            return name.substring(n + 1);
        }

        @Override
        public boolean isJava() {
            return this.packageRef.isJava();
        }

        public String toString() {
            return this.fqn;
        }

        @Override
        public boolean isObject() {
            return this.fqn.equals("java.lang.Object");
        }

        public boolean equals(Object other) {
            assert (other instanceof TypeRef);
            return this == other;
        }

        @Override
        public int compareTo(TypeRef other) {
            if (this == other) {
                return 0;
            }
            return this.fqn.compareTo(other.getFQN());
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isNested() {
            return this.binaryName.indexOf(36) >= 0;
        }
    }

    public static class PackageRef
    implements Comparable<PackageRef> {
        final String binaryName;
        final String fqn;
        final boolean java;

        PackageRef(String binaryName) {
            this.binaryName = Objects.requireNonNull(binaryName);
            this.fqn = Descriptors.binaryToFQN(binaryName);
            this.java = this.fqn.startsWith("java.");
        }

        PackageRef() {
            this.binaryName = "";
            this.fqn = ".";
            this.java = false;
        }

        public PackageRef getDuplicate() {
            return new PackageRef(this.binaryName + '~');
        }

        public String getFQN() {
            return this.fqn;
        }

        public String getBinary() {
            return this.binaryName;
        }

        public String getPath() {
            return this.binaryName;
        }

        public boolean isJava() {
            return this.java;
        }

        public String toString() {
            return this.fqn;
        }

        boolean isDefaultPackage() {
            return this.fqn.equals(".");
        }

        boolean isPrimitivePackage() {
            return this == PRIMITIVE_PACKAGE;
        }

        @Override
        public int compareTo(PackageRef other) {
            return this.fqn.compareTo(other.fqn);
        }

        public boolean equals(Object o) {
            assert (o instanceof PackageRef);
            return o == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean isMetaData() {
            if (this.isDefaultPackage()) {
                return true;
            }
            return Arrays.stream(Constants.METAPACKAGES).anyMatch(meta -> this.binaryName.startsWith((String)meta) && (this.binaryName.length() == meta.length() || this.binaryName.charAt(meta.length()) == '/'));
        }

        public boolean isValidPackageName() {
            int cp;
            int len = this.fqn.length();
            boolean start = true;
            for (int i = 0; i < len; i += Character.charCount(cp)) {
                cp = Character.codePointAt(this.fqn, i);
                if (start) {
                    if (!Character.isJavaIdentifierStart(cp)) {
                        return false;
                    }
                    start = false;
                    continue;
                }
                if (cp == 46) {
                    start = true;
                    continue;
                }
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
            return !start;
        }
    }

    @ProviderType
    public static interface TypeRef
    extends Comparable<TypeRef> {
        public String getBinary();

        public String getShorterName();

        public String getFQN();

        public String getPath();

        public boolean isPrimitive();

        public TypeRef getComponentTypeRef();

        public TypeRef getClassRef();

        public PackageRef getPackageRef();

        public String getShortName();

        public boolean isJava();

        public boolean isObject();

        public String getSourcePath();

        public String getDottedOnly();

        public boolean isArray();

        public boolean isNested();
    }

    @Deprecated
    public class Signature {
        public Map<String, Signature> typevariables = new HashMap<String, Signature>();
        public Signature type;
        public List<Signature> parameters;
    }

    @Deprecated
    public static enum SignatureType {
        TYPEVAR,
        METHOD,
        FIELD;

    }
}

