/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.slf4j;

import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.slf4j.BuildOperationAwareLogger;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.logging.slf4j.MessageRewritingBuildOperationAwareLogger;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class DefaultContextAwareTaskLogger
implements ContextAwareTaskLogger {
    private BuildOperationAwareLogger delegate;
    private OperationIdentifier fallbackOperationIdentifier = null;

    public DefaultContextAwareTaskLogger(Logger delegate) {
        this.delegate = Cast.cast(BuildOperationAwareLogger.class, delegate);
    }

    @Override
    public void setMessageRewriter(ContextAwareTaskLogger.MessageRewriter messageRewriter) {
        this.delegate = new MessageRewritingBuildOperationAwareLogger(this.delegate, messageRewriter);
    }

    @Override
    public void setFallbackBuildOperationId(OperationIdentifier operationIdentifier) {
        this.fallbackOperationIdentifier = operationIdentifier;
    }

    @Override
    public boolean isLifecycleEnabled() {
        return this.delegate.isLifecycleEnabled();
    }

    @Override
    public boolean isQuietEnabled() {
        return this.delegate.isQuietEnabled();
    }

    @Override
    public boolean isEnabled(LogLevel level) {
        return this.delegate.isEnabled(level);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    @Override
    public void trace(String msg) {
    }

    @Override
    public void trace(String format, Object arg) {
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
    }

    @Override
    public void trace(String format, Object ... arguments) {
    }

    @Override
    public void trace(String msg, Throwable t) {
    }

    @Override
    public void trace(Marker marker, String msg) {
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
    }

    private void log(LogLevel logLevel, Throwable throwable, String message) {
        this.delegate.log(logLevel, throwable, message, this.currentBuildOperationId());
    }

    private OperationIdentifier currentBuildOperationId() {
        OperationIdentifier buildOperationId = CurrentBuildOperationRef.instance().getId();
        return buildOperationId != null ? buildOperationId : this.fallbackOperationIdentifier;
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object arg) {
        this.log(logLevel, throwable, format, new Object[]{arg});
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(logLevel, throwable, format, new Object[]{arg1, arg2});
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object[] args) {
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, args);
        Throwable loggedThrowable = throwable == null ? tuple.getThrowable() : throwable;
        this.log(logLevel, loggedThrowable, tuple.getMessage());
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, message);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, format, arg);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, format, arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, (Throwable)null, format, arguments);
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, t, msg);
        }
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, msg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, format, arg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, format, arg1, arg2);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... argArray) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, (Throwable)null, format, argArray);
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, t, msg);
        }
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, message);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, format, arg);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, format, arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, (Throwable)null, format, arguments);
        }
    }

    @Override
    public void lifecycle(String message) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, null, message);
        }
    }

    @Override
    public void lifecycle(String message, Object ... objects) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, (Throwable)null, message, objects);
        }
    }

    @Override
    public void lifecycle(String message, Throwable throwable) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, throwable, message);
        }
    }

    @Override
    public void quiet(String message) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, null, message);
        }
    }

    @Override
    public void quiet(String message, Object ... objects) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, (Throwable)null, message, objects);
        }
    }

    @Override
    public void quiet(String message, Throwable throwable) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, throwable, message);
        }
    }

    @Override
    public void log(LogLevel level, String message) {
        if (this.isEnabled(level)) {
            this.log(level, null, message);
        }
    }

    @Override
    public void log(LogLevel level, String message, Object ... objects) {
        if (this.isEnabled(level)) {
            this.log(level, (Throwable)null, message, objects);
        }
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        if (this.isEnabled(level)) {
            this.log(level, throwable, message);
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, t, msg);
        }
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            this.log(BuildOperationAwareLogger.toLogLevel(marker), null, msg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            this.log(BuildOperationAwareLogger.toLogLevel(marker), null, format, arg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.log(BuildOperationAwareLogger.toLogLevel(marker), null, format, arg1, arg2);
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... argArray) {
        if (this.isInfoEnabled(marker)) {
            this.log(BuildOperationAwareLogger.toLogLevel(marker), (Throwable)null, format, argArray);
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.log(BuildOperationAwareLogger.toLogLevel(marker), t, msg);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, message);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, format, arg);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, format, arg1, arg2);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, (Throwable)null, format, arguments);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, t, msg);
        }
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, msg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, format, arg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, format, arg1, arg2);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... argArray) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, (Throwable)null, format, argArray);
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, t, msg);
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, message);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, format, arg);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, format, arg1, arg2);
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, (Throwable)null, format, arguments);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, t, msg);
        }
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, msg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, format, arg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, format, arg1, arg2);
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... argArray) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, (Throwable)null, format, argArray);
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, t, msg);
        }
    }
}

