/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.InstrumentableClosure;
import org.gradle.internal.classpath.InstrumentedClosuresTracker;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

@NonNullApi
public class DefaultInstrumentedClosuresTracker
implements InstrumentedClosuresTracker {
    private final Object2IntMap<InstrumentableClosure> currentClosuresEntries = new Object2IntOpenHashMap();

    @Override
    public void enterClosure(InstrumentableClosure thisClosure) {
        this.currentClosuresEntries.mergeInt((Object)thisClosure, 1, Integer::sum);
    }

    @Override
    public void leaveClosure(InstrumentableClosure thisClosure) {
        this.currentClosuresEntries.computeInt((Object)thisClosure, (key, oldValue) -> {
            if (oldValue == null) {
                throw new IllegalStateException("leaveClosure called with an untracked instance");
            }
            if (oldValue == 1) {
                return null;
            }
            return oldValue - 1;
        });
    }

    @Override
    public void hitInstrumentedDynamicCall() {
        this.currentClosuresEntries.keySet().forEach(InstrumentableClosure::makeEffectivelyInstrumented);
    }
}

