/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public abstract class Actions {
    static final Action<?> DO_NOTHING = new NullAction();

    public static <T> Action<T> doNothing() {
        return DO_NOTHING;
    }

    public static <T> Action<T> composite(Iterable<? extends Action<? super T>> actions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Action<T> action : actions) {
            if (!Actions.doesSomething(action)) continue;
            builder.add(action);
        }
        return Actions.composite(builder.build());
    }

    public static <T> Action<T> composite(List<? extends Action<? super T>> actions) {
        if (actions.isEmpty()) {
            return Actions.doNothing();
        }
        if (actions.size() == 1) {
            return (Action)Cast.uncheckedCast(actions.get(0));
        }
        return new CompositeAction(actions);
    }

    @SafeVarargs
    public static <T> Action<T> composite(Action<? super T> ... actions) {
        ArrayList<Action<? super T>> filtered = Lists.newArrayListWithCapacity(actions.length);
        for (Action<? super T> action : actions) {
            if (!Actions.doesSomething(action)) continue;
            filtered.add(action);
        }
        return Actions.composite(filtered);
    }

    public static <T> Action<T> toAction(@Nullable Runnable runnable) {
        if (runnable == null) {
            return Actions.doNothing();
        }
        return new RunnableActionAdapter(runnable);
    }

    public static <T> Action<T> filter(Action<? super T> action, Spec<? super T> filter) {
        return new FilteredAction<T>(action, filter);
    }

    public static <T> T with(T instance, Action<? super T> action) {
        action.execute(instance);
        return instance;
    }

    public static <T> Action<T> add(final Collection<? super T> collection) {
        return new Action<T>(){

            @Override
            public void execute(T t) {
                collection.add(t);
            }
        };
    }

    public static <T> Action<T> set(Action<T> ... actions) {
        return ImmutableActionSet.of(actions);
    }

    private static boolean doesSomething(Action<?> action) {
        return action != DO_NOTHING;
    }

    private static class FilteredAction<T>
    implements Action<T> {
        private final Spec<? super T> filter;
        private final Action<? super T> action;

        public FilteredAction(Action<? super T> action, Spec<? super T> filter) {
            this.filter = filter;
            this.action = action;
        }

        @Override
        public void execute(T t) {
            if (this.filter.isSatisfiedBy(t)) {
                this.action.execute(t);
            }
        }
    }

    private static class RunnableActionAdapter<T>
    implements Action<T> {
        private final Runnable runnable;

        private RunnableActionAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void execute(T t) {
            this.runnable.run();
        }

        public String toString() {
            return "RunnableActionAdapter{runnable=" + this.runnable + "}";
        }
    }

    private static class CompositeAction<T>
    implements Action<T> {
        private final List<? extends Action<? super T>> actions;

        private CompositeAction(List<? extends Action<? super T>> actions) {
            this.actions = actions;
        }

        @Override
        public void execute(T item) {
            for (Action<T> action : this.actions) {
                action.execute(item);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeAction that = (CompositeAction)o;
            return this.actions.equals(that.actions);
        }

        public int hashCode() {
            return this.actions.hashCode();
        }
    }

    private static class NullAction<T>
    implements Action<T>,
    Serializable {
        private NullAction() {
        }

        @Override
        public void execute(T t) {
        }
    }
}

