/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.release.util;

import com.liferay.release.util.ReleaseEntry;
import com.liferay.release.util.internal.ReleaseProvider;
import com.liferay.release.util.internal.constants.ReleaseConstants;
import com.liferay.release.util.internal.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReleaseUtil {
    private static ReleaseProvider _releaseProvider;

    public static <T> T getFromReleaseEntry(String releaseKey, Function<ReleaseEntry, T> function) {
        ReleaseEntry releaseEntry = ReleaseUtil.getReleaseEntry(releaseKey);
        if (releaseEntry != null) {
            return function.apply(releaseEntry);
        }
        return null;
    }

    public static List<ReleaseEntry> getReleaseEntries() {
        ReleaseUtil._checkInstance();
        return new ArrayList<ReleaseEntry>(_releaseProvider.getReleaseEntries());
    }

    public static ReleaseEntry getReleaseEntry(String releaseKey) {
        Map<String, ReleaseEntry> releaseEntryMap = ReleaseUtil.getReleaseEntryMap();
        return releaseEntryMap.get(releaseKey);
    }

    public static Map<String, ReleaseEntry> getReleaseEntryMap() {
        ReleaseUtil._checkInstance();
        return new HashMap<String, ReleaseEntry>(_releaseProvider.getReleaseEntryMap());
    }

    public static Stream<ReleaseEntry> getReleaseEntryStream() {
        List<ReleaseEntry> releaseEntries = ReleaseUtil.getReleaseEntries();
        return releaseEntries.stream();
    }

    public static void initialize() {
        ReleaseUtil.initialize(7L);
    }

    public static void initialize(long maxAge) {
        ArrayList<String> releasesMirrors = new ArrayList<String>(StringUtil.split(System.getenv("LIFERAY_RELEASES_MIRRORS")));
        releasesMirrors.add("https://releases-cdn.liferay.com");
        ReleaseUtil.initialize(maxAge, releasesMirrors, ReleaseConstants.CACHE_DIR);
    }

    public static void initialize(long maxAge, List<String> releasesMirrors, File cacheDir) {
        _releaseProvider = new ReleaseProvider(maxAge, releasesMirrors, cacheDir);
    }

    private static void _checkInstance() {
        if (_releaseProvider == null) {
            ReleaseUtil.initialize();
        }
    }
}

