/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FileWatcher {
    private static final WatchEvent.Kind[] _WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE};
    private final Map<WatchKey, Path> _keys;
    private final boolean _recursive;
    private final WatchService _watcher;

    public static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public FileWatcher(Path baseDir, boolean recursive, Consumer<Path> consumer) throws IOException {
        this(baseDir, null, recursive, consumer);
    }

    public FileWatcher(Path baseDir, Path fileToWatch, boolean recursive, Consumer<Path> consumer) throws IOException {
        FileSystem fileSystem = FileSystems.getDefault();
        this._watcher = fileSystem.newWatchService();
        this._recursive = recursive;
        this._keys = new HashMap<WatchKey, Path>();
        System.out.format("Scanning %s\n", baseDir);
        if (recursive) {
            this._registerAll(baseDir);
        } else {
            this._register(baseDir);
        }
        this.processEvents(fileToWatch, consumer);
    }

    public void processEvents(Path fileToWatch, Consumer<Path> consumer) {
        while (true) {
            boolean valid;
            WatchKey key;
            try {
                key = this._watcher.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Path dir = this._keys.get(key);
            if (dir == null) {
                System.err.println("WatchKey not recognized!!");
                continue;
            }
            HashSet<Path> reportModified = new HashSet<Path>();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = FileWatcher.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (!(!child.equals(fileToWatch) && fileToWatch != null || kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY)) {
                    reportModified.add(child);
                }
                if (!this._recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this._registerAll(child);
                }
                catch (IOException iOException) {}
            }
            if (!reportModified.isEmpty()) {
                for (Path modified : reportModified) {
                    try {
                        consumer.consume(modified);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (valid = key.reset()) continue;
            this._keys.remove(key);
            if (this._keys.isEmpty()) break;
        }
    }

    private void _register(Path dir) throws IOException {
        WatchEvent.Modifier modifier = null;
        try {
            Class<?> c = Class.forName("com.sun.nio.file.SensitivityWatchEventModifier");
            Field f = c.getField("HIGH");
            modifier = (WatchEvent.Modifier)f.get(c);
        }
        catch (Exception c) {
            // empty catch block
        }
        WatchKey key = modifier != null ? dir.register(this._watcher, _WATCH_KINDS, modifier) : dir.register(this._watcher, _WATCH_KINDS);
        this._keys.put(key, dir);
    }

    private void _registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileWatcher.this._register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static interface Consumer<E> {
        public void consume(E var1);
    }
}

