/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.liferay.blade.cli.command.BaseCommand;
import com.liferay.blade.cli.command.ShellArgs;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.gogo.shell.client.GogoShellClient;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ShellCommand
extends BaseCommand<ShellArgs> {
    @Override
    public void execute() throws Exception {
        int port;
        ShellArgs shellArgs = (ShellArgs)this.getArgs();
        String host = shellArgs.getHost() != null ? shellArgs.getHost() : "localhost";
        int n = port = shellArgs.getPort() != 0 ? shellArgs.getPort() : 11311;
        if (!BladeUtil.canConnect(host, port)) {
            this._addError("sh", "Unable to connect to gogo shell on " + host + ":" + port);
            return;
        }
        List<String> args = shellArgs.getArgs();
        String gogoCommand = args.stream().collect(Collectors.joining(" "));
        this._executeCommand(gogoCommand, host, port);
    }

    @Override
    public Class<ShellArgs> getArgsClass() {
        return ShellArgs.class;
    }

    private void _addError(String prefix, String msg) {
        this.getBladeCLI().addErrors(prefix, Collections.singleton(msg));
    }

    private void _executeCommand(String gogoCommand, String host, int port) throws Exception {
        try (GogoShellClient client = new GogoShellClient(host, port);){
            String response = client.send(gogoCommand);
            this.getBladeCLI().out(response);
        }
    }
}

