/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.blade.cli.command.BaseArgs;
import com.liferay.blade.cli.command.CommandType;
import com.liferay.blade.cli.command.validator.LiferayDefaultVersionValidator;
import com.liferay.blade.cli.command.validator.LiferayMoreVersionValidator;
import com.liferay.blade.cli.command.validator.ParameterPossibleValues;

@Parameters(commandDescription="Initializes a new Liferay workspace", commandNames={"init"})
public class InitArgs
extends BaseArgs {
    @Parameter(description="Only used with (-l|--list) option, list all Liferay products keys", names={"--all"})
    private boolean _all;
    @Parameter(description="Initialize a workspace even if there are files located in target location", names={"-f", "--force"})
    private boolean _force;
    @Parameter(description="The option for Liferay Platform product. (portal)|(dxp)", names={"--liferay-product"})
    private String _liferayProduct = "portal";
    @Parameter(description="The Liferay product to target. Typing \"more\" will show all product versions.", names={"-v", "--liferay-version"}, required=true, validateValueWith={LiferayMoreVersionValidator.class})
    @ParameterPossibleValues(more=LiferayMoreVersionValidator.class, value=LiferayDefaultVersionValidator.class)
    private String _liferayVersion;
    @Parameter(description="List Liferay products that can be configured during initial workspace creation", names={"-l", "--list"})
    private boolean _list;
    @Parameter(description="[name]")
    private String _name;
    @Parameter(description="force to refresh workspace template", names={"-r", "--refresh"})
    private boolean _refresh;
    @Parameter(description="upgrade plugins-sdk from 6.2 to 7.0", names={"-u", "--upgrade"})
    private boolean _upgrade;

    @Override
    public CommandType getCommandType() {
        return CommandType.NON_WORKSPACE;
    }

    public String getLiferayProduct() {
        return this._liferayProduct;
    }

    public String getLiferayVersion() {
        return this._liferayVersion;
    }

    public String getName() {
        return this._name;
    }

    public boolean isAll() {
        return this._all;
    }

    public boolean isForce() {
        return this._force;
    }

    public boolean isList() {
        return this._list;
    }

    public boolean isRefresh() {
        return this._refresh;
    }

    public boolean isUpgrade() {
        return this._upgrade;
    }

    public void setAll(boolean all) {
        this._all = all;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setLiferayProduct(String liferayProduct) {
        this._liferayProduct = liferayProduct;
    }

    public void setLiferayVersion(String liferayVersion) {
        this._liferayVersion = liferayVersion;
    }

    public void setList(boolean list) {
        this._list = list;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRefresh(boolean refresh) {
        this._refresh = refresh;
    }

    public void setUpgrade(boolean upgrade) {
        this._upgrade = upgrade;
    }
}

