/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blade.cli;

import com.liferay.blade.cli.BladeCLI;
import com.liferay.blade.cli.WorkspaceProvider;
import com.liferay.blade.cli.util.BladeUtil;
import com.liferay.blade.cli.util.Prompter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class BladeSettings {
    private final Properties _properties = new Properties();
    private final File _settingsFile;

    public BladeSettings(File settingsFile) throws IOException {
        this._settingsFile = settingsFile;
        if (this._settingsFile.exists()) {
            this.load();
        }
    }

    public String getLiferayVersionDefault() {
        if (this._properties.getProperty("liferay.version.default") != null) {
            return this._properties.getProperty("liferay.version.default");
        }
        return "7.4";
    }

    public String getProfileName() {
        return this._properties.getProperty("profile.name");
    }

    public void load() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this._settingsFile);){
            this._properties.load(fileInputStream);
        }
    }

    public void migrateWorkspaceIfNecessary(BladeCLI bladeCLI) throws IOException {
        this.migrateWorkspaceIfNecessary(bladeCLI, null);
    }

    public void migrateWorkspaceIfNecessary(BladeCLI bladeCLI, String profileName) throws IOException {
        WorkspaceProvider workspaceProvider = bladeCLI.getWorkspaceProvider(this._settingsFile);
        if (workspaceProvider != null && workspaceProvider.isWorkspace(bladeCLI)) {
            File workspaceDirectory = workspaceProvider.getWorkspaceDir(this._settingsFile);
            File pomFile = new File(workspaceDirectory, "pom.xml");
            boolean shouldPrompt = false;
            if (pomFile.exists()) {
                if (!this._settingsFile.exists()) {
                    shouldPrompt = true;
                } else {
                    String profilePromptDisabled = this._properties.getProperty("profile.prompt.disabled", "false");
                    if (!Objects.equals(profilePromptDisabled, "true") && !Objects.equals(this.getProfileName(), "maven")) {
                        shouldPrompt = true;
                    }
                }
            }
            if (shouldPrompt) {
                if (!BladeUtil.isEmpty(profileName)) {
                    this.setProfileName(profileName);
                    this.save();
                    return;
                }
                String question = "WARNING: blade commands will not function properly in a Maven workspace unless the blade profile is set to \"maven\". Should the settings for this workspace be updated?";
                if (Prompter.confirm(question, bladeCLI.in(), bladeCLI.out(), Optional.of(true))) {
                    this.setProfileName("maven");
                    this.save();
                } else {
                    question = "Should blade remember this setting for this workspace?";
                    if (Prompter.confirm(question, bladeCLI.in(), bladeCLI.out(), Optional.of(true))) {
                        this._properties.setProperty("profile.prompt.disabled", "true");
                        this.save();
                    }
                }
            }
        }
    }

    public void save() throws IOException {
        if (!this._settingsFile.exists()) {
            File parentDir = this._settingsFile.getParentFile();
            parentDir.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(this._settingsFile);){
            this._properties.store(out, null);
        }
    }

    public void setLiferayVersionDefault(String liferayVersion) {
        this._properties.setProperty("liferay.version.default", liferayVersion);
    }

    public void setProfileName(String profileName) {
        this._properties.setProperty("profile.name", profileName);
    }
}

