/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.TaskSchedulingPreparer;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.StateTransitionController;

public class VintageBuildModelController
implements BuildModelController {
    private final ProjectsPreparer projectsPreparer;
    private final GradleInternal gradle;
    private final TaskSchedulingPreparer taskGraphPreparer;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final StateTransitionController<Stage> controller = new StateTransitionController((StateTransitionController.State)Stage.Created);

    public VintageBuildModelController(GradleInternal gradle, ProjectsPreparer projectsPreparer, TaskSchedulingPreparer taskSchedulingPreparer, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.taskGraphPreparer = taskSchedulingPreparer;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
    }

    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.LoadSettings);
        return this.gradle.getSettings();
    }

    public GradleInternal getConfiguredModel() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    public void prepareToScheduleTasks() {
        this.doBuildStages(Stage.ScheduleTasks);
    }

    public void scheduleRequestedTasks() {
        this.doBuildStages(Stage.TaskGraph);
    }

    private void doBuildStages(Stage upTo) {
        this.prepareSettings();
        if (upTo == Stage.LoadSettings) {
            return;
        }
        this.prepareProjects();
        if (upTo == Stage.Configure) {
            return;
        }
        this.prepareTaskGraph();
        if (upTo == Stage.ScheduleTasks) {
            return;
        }
        this.prepareTaskExecution();
    }

    private void prepareSettings() {
        this.controller.transitionIfNotPreviously((StateTransitionController.State)Stage.Created, (StateTransitionController.State)Stage.LoadSettings, () -> this.settingsPreparer.prepareSettings(this.gradle));
    }

    private void prepareProjects() {
        this.controller.transitionIfNotPreviously((StateTransitionController.State)Stage.LoadSettings, (StateTransitionController.State)Stage.Configure, () -> this.projectsPreparer.prepareProjects(this.gradle));
    }

    private void prepareTaskGraph() {
        this.controller.transitionIfNotPreviously((StateTransitionController.State)Stage.Configure, (StateTransitionController.State)Stage.ScheduleTasks, () -> this.taskGraphPreparer.prepareForTaskScheduling(this.gradle));
    }

    private void prepareTaskExecution() {
        this.controller.transitionIfNotPreviously((StateTransitionController.State)Stage.ScheduleTasks, (StateTransitionController.State)Stage.TaskGraph, () -> this.taskExecutionPreparer.prepareForTaskExecution(this.gradle));
    }

    private static enum Stage implements StateTransitionController.State
    {
        Created,
        LoadSettings,
        Configure,
        ScheduleTasks,
        TaskGraph;

    }
}

